unit MapperInfo;

interface

Const
 CurrentMapperInterface = $00010001;

Type
// Function definitions
 PassS32          = Procedure(Which:LongInt); cDecl;
 PassS32S32       = Procedure(Which1:LongInt; Which2:LongInt); cDecl;
 PassS32S32S32    = Procedure(Bank:LongInt; Which:LongInt; Size:LongInt); cDecl;
 PassS32S32S32S32 = Procedure(P1,P2,P3,P4:LongInt); cDecl;
 PassNone         = Procedure; cDecl;
 PassPChar        = Procedure(Text:PChar); cDecl;
 PassS32S32RS32   = Function(Bank:LongInt; Size:LongInt):LongInt; cDecl;

 TWriteFunc   = Procedure(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
 TReadFunc    = Function(Page:LongInt; Where:LongInt):LongInt; cDecl;

 PassS32STW   = Procedure(Page:LongInt; New:TWriteFunc); cDecl;
 PassS32STR   = Procedure(Page:LongInt; New:TReadFunc); cDecl;
 PassS32RTW   = Function(Page:LongInt):TWriteFunc; cDecl;
 PassS32RTR   = Function(Page:LongInt):TReadFunc; cDecl;

// The Info returned by the Mapper DLL on LoadMapper
 PMapperInfo  = ^TMapperInfo;
 TMapperInfo  = Packed Record
                 MapperNum:LongInt;
                 VersionLo:Word;   // Low version number
                 VersionHi:Word;   // High version number
                 BankSize:LongInt; // Minimum granularity of the banks
                 Name:PChar;
                 Author:PChar;
                end;

// Function definitions for Load Mapper & Unload Mapper
 TLoadMapper  = Function(VersionNeeded:LongInt):PMapperInfo; cDecl;
 TUnloadMapper= Procedure; cDecl;

// Array used for Mapper Info saving/Restoring
 Ar128        = Array[$00..$7F] of Byte;
 TSaveMI      = Procedure(var MI:Ar128); cDecl;   // For saving Mapper Specific data
 TLoadMI      = Procedure(const MI:Ar128); cDecl; // For restoring Mapper Specific data

// The Info passed to the Mapper DLL on InitMapper
 PMapperParam = ^TMapperParam;
 TMapperParam = Packed Record
                // Mapper Info
                Flag1:Byte; // Contains mirroring info and such
                Flag2:Byte; // The other byte
                HasCHR_ROM:Byte;  // 1 if true, 0 if false
                Unused1:Byte; // As of now
                // Procs for setting/getting write/read handlers
                SetWriteHandler:PassS32STW;
                SetReadHandler:PassS32STR;
                GetWriteHandler:PassS32RTW;
                GetReadHandler:PassS32RTR;
                // SetPRG's
                SetPRG_67:PassS32;
                SetPRG_89:PassS32;
                SetPRG_AB:PassS32;
                SetPRG_CD:PassS32;
                SetPRG_EF:PassS32;
                SetPRG_89AB:PassS32;
                SetPRG_CDEF:PassS32;
                SetPRG_89ABCDEF:PassS32;
                SetPRG_Custom:PassS32S32S32;
                GetPRG_Custom:PassS32S32RS32;
                // SetCHR's
                SetCHR_0000_03FF:PassS32;
                SetCHR_0400_07FF:PassS32;
                SetCHR_0800_0BFF:PassS32;
                SetCHR_0C00_0FFF:PassS32;
                SetCHR_1000_13FF:PassS32;
                SetCHR_1400_17FF:PassS32;
                SetCHR_1800_1BFF:PassS32;
                SetCHR_1C00_1FFF:PassS32;
                SetCHR_0000_07FF:PassS32;
                SetCHR_0800_0FFF:PassS32;
                SetCHR_1000_17FF:PassS32;
                SetCHR_1800_1FFF:PassS32;
                SetCHR_0000_0FFF:PassS32;
                SetCHR_1000_1FFF:PassS32;
                SetCHR_0000_1FFF:PassS32;
                SetCHR_Custom:PassS32S32S32;
                GetCHR_Custom:PassS32S32RS32;
                SetCHR_RAM:PassS32;
                // SetMirrors
                Mirror_H:PassNone;
                Mirror_V:PassNone;
                Mirror_4:PassNone;
                Mirror_S0:PassNone;
                Mirror_S1:PassNone;
                Mirror_Custom:PassS32S32S32S32;
                // External Sound chips
                VRC6Write:PassS32S32S32;
                // Callback for debugging purposes
                DbgOut:PassPChar;
                // More SetCHR functions
                SetCHR_RAM_0000_03FF:PassS32;
                SetCHR_RAM_0400_07FF:PassS32;
                SetCHR_RAM_0800_0BFF:PassS32;
                SetCHR_RAM_0C00_0FFF:PassS32;
                SetCHR_RAM_1000_13FF:PassS32;
                SetCHR_RAM_1400_17FF:PassS32;
                SetCHR_RAM_1800_1BFF:PassS32;
                SetCHR_RAM_1C00_1FFF:PassS32;
               end;
// Function definition for Init Mapper
 TInitMapper  = Procedure(Const MapperParam:TMapperParam); cDecl;

// Function definition for other
 THBlank      = Function(ScanLine:LongInt; Byte2001:LongInt):LongInt; cDecl; // Returns 0 if no IRQ, 1 else
 TTileHandler = Function(Table:LongInt; TileNum:LongInt):LongInt; cDecl;     // Returns 0 if there was no change, 1 if change.


implementation

end.
