extern "C" 
{

	#define WIN32_LEAN_AND_MEAN 
	#include <windows.h>
	#include "Mapper_Def.h"

	char author[]	= "PrOxY";
	char name[]		= "100-in-1";

	TMapperParam	* MP			= NULL;	// Contains all variables and mapper functions
	
	// Variables for the Mapper itself
	BYTE	Map15_BankAddr;
	BYTE	Map15_SwapReg;

	
	NESTENMAPPER mapper = 
	{
		15,		// Mapper Number
		0,		// Lo Version Number
		1,		// Hi Version Number
		8192,	// Min Switch Size
		name,	// Name of this mapper
		author	// My Name :)
	};

	//-----------------------------------------------------------------------------
	// Name: SaveMI(char* MI) 
	// Desc: Saves the ROM state
	//-----------------------------------------------------------------------------  	
	__declspec(dllexport) void SaveMI(char* MI) 
	{

	}

	//-----------------------------------------------------------------------------
	// Name: LoadMI(char *MI) 
	// Desc: Loads the Mapper ROM state
	//-----------------------------------------------------------------------------  
	__declspec(dllexport) void LoadMI(char* MI) 
	{

	}

	//-----------------------------------------------------------------------------
	// Name: 
	// Desc: 
	//-----------------------------------------------------------------------------  
	__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded) 
	{

		// Check interface Version
		if (VersionNeeded > CurrentMapperInterface)
		{
			MessageBox(0, "DLL is not compatible with the current mapper interface!", "Mapper", MB_OK);
			return NULL;
		}
		else
			return &mapper;
	}

	//-----------------------------------------------------------------------------
	// Name: 
	// Desc: 
	//-----------------------------------------------------------------------------  
	__declspec(dllexport) void UnloadMapper(void) 
	{
		// Nothing 4 now.
	}

	//-----------------------------------------------------------------------------
	// Name: Mapper15_Write(int Bank, int Where, int What)
	// Desc: Write Handler
	//-----------------------------------------------------------------------------  
	void Mapper15_Write(int Bank, int Where, int What)
	{
		Map15_BankAddr = (What & 0x3F);

		switch( Where )
		{
		case 0x000:
			Map15_SwapReg = ( What & 0x80 );

			MP->SetPRG_89AB( Map15_BankAddr );
			MP->SetPRG_CDEF( Map15_BankAddr + 1 );		

			if( What & 0x40)	MP->Mirror_H();
			else				MP->Mirror_V();


			break;
			
		case 0x001:
			Map15_SwapReg = ( What & 0x80 );
			
			MP->SetPRG_CDEF( Map15_BankAddr );
			break;

		case 0x002:

			if ( What & 0x80 )	// upper half of 16k
			{
				MP->SetPRG_89( ( Map15_BankAddr << 1 ) + 1 );
				MP->SetPRG_AB( ( Map15_BankAddr << 1 ) + 1 );
				MP->SetPRG_CD( ( Map15_BankAddr << 1 ) + 1 );
				MP->SetPRG_EF( ( Map15_BankAddr << 1 ) + 1 );
			}
			else
			{
				MP->SetPRG_89( ( Map15_BankAddr << 1 ) );
				MP->SetPRG_AB( ( Map15_BankAddr << 1 ) );
				MP->SetPRG_CD( ( Map15_BankAddr << 1 ) );
				MP->SetPRG_EF( ( Map15_BankAddr << 1 ) );
			}	
			break;

		case 0x003:
			Map15_SwapReg = ( What & 0x80 );

			MP->SetPRG_CDEF( Map15_BankAddr );

			if( What & 0x40 )	MP->Mirror_H();
			else				MP->Mirror_V();

			break;
		}
	}


	//-----------------------------------------------------------------------------
	// Name: InitMapper( TMapperParam *MapperParam )
	// Desc: Initialization of the mapper
	//-----------------------------------------------------------------------------  
	__declspec(dllexport) void InitMapper( TMapperParam *MapperParam )
	{
		// Copy the passed parameters to get access to the functions
		MP = MapperParam;

		// Set write handler
		MP->SetWriteHandler(0x08, Mapper15_Write);

		// Set first bank
		MP->SetPRG_89ABCDEF( 0 );

		// should always be CHR_RAM
		MP->SetCHR_RAM(0);

		// Mirroring
		if ((MP->Flag1 & 1) != 0)	MP->Mirror_V();
		else						MP->Mirror_H();

		//initialize variables
		Map15_BankAddr	= 0;
		Map15_SwapReg	= 0;

	}

}