
extern "C" {

	#define WIN32_LEAN_AND_MEAN 
	#include <windows.h>
	#include "MInfo.h"

	char author[]	= "PrOxY";
	char name[]		= "72-in-1";

	DWORD Map225_PageSize		= 0;	//Size of page to be swaped;
	DWORD Map225_PageSelect		= 0;	//HI or LO half of page

	NESTENMAPPER mapper = 
	{
		225,	// Mapper Number
		0,		// Lo Version Number
		1,		// Hi Version Number
		16384,	// Min Switch Size
		name,	// Name of this mapper
		author	// My Name :)
	};

	TMapperParam	* MP			= NULL;	// Contains all variables and mapper functions


	
	//-----------------------------------------------------------------------------
	// Name: Map225_Write(int Bank, int Where, int What)
	// Desc: handles Mapper writes
	//-----------------------------------------------------------------------------  
	void Map225_Write(int Bank, int Where, int What)
	{

		
		// Select VROM
		MP->SetCHR_0000_1FFF(Where & 0x1F);		
		
		// Upper or lower Half?
		// No effect if Map225_PageSize
		Map225_PageSelect	= Where & 0x40;

		// Size of Page?
		Map225_PageSize		= Bank & 0x01;
		
		// Mirroring
		if ( (Bank & 0x02) == 0 )	MP->Mirror_V();
		else						MP->Mirror_H();

		

		// Get number of First 1/4 of a 32k bank
		BYTE Map225_Base_Bank = (BYTE)( ( Where & 0xF80 ) >> 7 );

		if ( Map225_PageSize )
		{
			if ( Map225_PageSelect )
			{
				// both are high half
				MP->SetPRG_89AB( (Map225_Base_Bank << 1 ) + 1);
				MP->SetPRG_CDEF( (Map225_Base_Bank << 1 ) + 1);
			}
			else
			{
				// both are low half
				MP->SetPRG_89AB( (Map225_Base_Bank << 1 ) );
				MP->SetPRG_CDEF( (Map225_Base_Bank << 1 ) );

			}
		}
		else
		{
			// entire 32k
			MP->SetPRG_89ABCDEF( Map225_Base_Bank );

		}

	}


	//-----------------------------------------------------------------------------
	// Name: SaveMI(char* MI) 
	// Desc: Saves the ROM state
	//-----------------------------------------------------------------------------  	
	__declspec(dllexport) void SaveMI(char* MI) 
	{

	}

	//-----------------------------------------------------------------------------
	// Name: LoadMI(char *MI) 
	// Desc: Loads the Mapper ROM state
	//-----------------------------------------------------------------------------  
	__declspec(dllexport) void LoadMI(char* MI) 
	{

	}

	//-----------------------------------------------------------------------------
	// Name: LoadMapper(int VersionNeeded) 
	// Desc: loads up mapper and returns structure for ident
	//-----------------------------------------------------------------------------  
	__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded) 
	{

		// Check interface Version
		if (VersionNeeded > CurrentMapperInterface)
		{
			MessageBox(0, "DLL is not compatible with the current mapper interface!", "Mapper4", MB_OK);
			return NULL;
		}
		else
			return &mapper;
	}

	//-----------------------------------------------------------------------------
	// Name: UnloadMapper(void) 
	// Desc: unloads mapper ( releases memory and such )
	//-----------------------------------------------------------------------------  
	__declspec(dllexport) void UnloadMapper(void) 
	{
		// Nothing 4 now.
	}


	//-----------------------------------------------------------------------------
	// Name: InitMapper( TMapperParam *MapperParam )
	// Desc: Initialization of the mapper
	//-----------------------------------------------------------------------------  
	__declspec(dllexport) void InitMapper( TMapperParam *MapperParam )
	{
		// Copy the passed parameters to get access to the functions
		MP = MapperParam;

		// Valid Writes
		MP->SetWriteHandler(0x08, Map225_Write);
		MP->SetWriteHandler(0x09, Map225_Write);
		MP->SetWriteHandler(0x0A, Map225_Write);
		MP->SetWriteHandler(0x0B, Map225_Write);
		MP->SetWriteHandler(0x0C, Map225_Write);
		MP->SetWriteHandler(0x0D, Map225_Write);
		MP->SetWriteHandler(0x0E, Map225_Write);
		MP->SetWriteHandler(0x0F, Map225_Write);

		Map225_PageSize		= 0x00;
		Map225_PageSelect	= 0x00;


		// First 32k at startup
		MP->SetPRG_89ABCDEF(0); 

		// First 8k at startup
		MP->SetCHR_0000_1FFF(0);

		// Standard Mirroring ( should be vertical in ROM )
		if ((MP->Flag1 & 1) != 0)	MP->Mirror_V();
		else						MP->Mirror_H();
	}


}