extern "C" 
{

	#define WIN32_LEAN_AND_MEAN 
	#include <windows.h>
	#include "Mapper_Def.h"

	char author[]	= "PrOxY";
	char name[]		= "Sunsoft FME-7";

	TMapperParam	* MP			= NULL;	// Contains all variables and mapper functions
	
	// Variables for the Mapper itself
	static BYTE Map69_Reg_Num;
	static WORD Map69_IRQ_Counter;
	static BYTE Map69_IRQ_Enabled;

	
	NESTENMAPPER mapper = 
	{
		69,		// Mapper Number
		0,		// Lo Version Number
		1,		// Hi Version Number
		8192,	// Min Switch Size
		name,	// Name of this mapper
		author	// My Name :)
	};

	//-----------------------------------------------------------------------------
	// Name: SaveMI(char* MI) 
	// Desc: Saves the ROM state
	//-----------------------------------------------------------------------------  	
	__declspec(dllexport) void SaveMI(char* MI) 
	{

	}

	//-----------------------------------------------------------------------------
	// Name: LoadMI(char *MI) 
	// Desc: Loads the Mapper ROM state
	//-----------------------------------------------------------------------------  
	__declspec(dllexport) void LoadMI(char* MI) 
	{

	}

	//-----------------------------------------------------------------------------
	// Name: 
	// Desc: 
	//-----------------------------------------------------------------------------  
	__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded) 
	{

		// Check interface Version
		if (VersionNeeded > CurrentMapperInterface)
		{
			MessageBox(0, "DLL is not compatible with the current mapper interface!", "Mapper", MB_OK);
			return NULL;
		}
		else
			return &mapper;
	}

	//-----------------------------------------------------------------------------
	// Name: 
	// Desc: 
	//-----------------------------------------------------------------------------  
	__declspec(dllexport) void UnloadMapper(void) 
	{
		// Nothing 4 now.
	}


	//-----------------------------------------------------------------------------
	// Name: Mapper69_Write_Command(int Bank, int Where, int What)
	// Desc: Selects command
	//-----------------------------------------------------------------------------  
	void Mapper69_Write_Command(int Bank, int Where, int What)
	{
		switch( Where )
		{
		case 0x000:
			Map69_Reg_Num = ( What & 0x0F );
			break;
		}

	}

	//-----------------------------------------------------------------------------
	// Name: Mapper69_Write_Execute(int Bank, int Where, int What)
	// Desc: executes command
	//-----------------------------------------------------------------------------  
	void Mapper69_Write_Execute(int Bank, int Where, int What)
	{
		switch ( Where )
		{
		case 0x000:
			switch ( Map69_Reg_Num )
			{
			case 0:	MP->SetCHR_0000_03FF( What ); break;
			case 1:	MP->SetCHR_0400_07FF( What ); break;
			case 2:	MP->SetCHR_0800_0BFF( What ); break;
			case 3:	MP->SetCHR_0C00_0FFF( What ); break;
			case 4:	MP->SetCHR_1000_13FF( What ); break;
			case 5:	MP->SetCHR_1400_17FF( What ); break;
			case 6:	MP->SetCHR_1800_1BFF( What ); break;
			case 7:	MP->SetCHR_1C00_1FFF( What ); break;

			case 8:	
				if ( (What & 0x40) == 0 )
					MP->SetPRG_67( What & 0x3F );
				else
				{
					if ( What & 0x80 )
					{
						//$6000 = WRAM?
					}
					else
					{
						//$6000 = Random crap?
					}
				}
				break;

			case 9: MP->SetPRG_89( What ); break;
			case 10: MP->SetPRG_AB( What ); break;
			case 11: MP->SetPRG_CD( What ); break;
			case 12:
				// dunno ..mirroring guessing seems right			
				switch (What & 3) 
				{
 				case 2:	MP->Mirror_S0(); break;
				case 1:	MP->Mirror_S1(); break;
				case 3:	MP->Mirror_V();	break;
 				case 0:	MP->Mirror_H(); break;
				}
				break;
			case 13:
				Map69_IRQ_Enabled = What;
				break;
			case 14:
				Map69_IRQ_Counter = ( Map69_IRQ_Counter & 0xFF00 ) | What;
				break;
			case 15:
				Map69_IRQ_Counter = ( Map69_IRQ_Counter & 0x00FF ) | ( What << 8 );
				break;

			}
			break;
		}
	}


	//-----------------------------------------------------------------------------
	// Name: InitMapper( TMapperParam *MapperParam )
	// Desc: Initialization of the mapper
	//-----------------------------------------------------------------------------  
	__declspec(dllexport) void InitMapper( TMapperParam *MapperParam )
	{
		// Copy the passed parameters to get access to the functions
		MP = MapperParam;

		// Set write handler
		MP->SetWriteHandler(0x08, Mapper69_Write_Command);
		MP->SetWriteHandler(0x0A, Mapper69_Write_Execute);

	 
		MP->SetPRG_89AB( 0 );
		MP->SetPRG_CDEF( -1 );

		MP->SetCHR_0000_1FFF( 0x0 );

		Map69_Reg_Num		= 0;
		Map69_IRQ_Counter	= 0;
		Map69_IRQ_Enabled	= 0;


		// Mirroring
		if ((MP->Flag1 & 1) != 0)	MP->Mirror_V();
		else						MP->Mirror_H();

	}

	//-----------------------------------------------------------------------------
	// Name: HBlank(int ScanLine, int Byte2001)
	// Desc: called every hblank ( controls IRQ in mapper )
	//-----------------------------------------------------------------------------  
	__declspec(dllexport) int HBlank(int ScanLine, int Byte2001)
	{
		
	 
		if (ScanLine > 239) return 0; // Do nothing

		if ( (Map69_IRQ_Enabled != 0) )
		{
			Map69_IRQ_Counter++;
			if (Map69_IRQ_Counter == 0xFFFF)
			{				
				return 1;	//IRQ
			}
		}
		return 0;
	}

}