#ifndef _MAPPER_DEF_H_
#define _MAPPER_DEF_H_

#define CurrentMapperInterface 0x00010000


// The Info returned by the Mapper DLL on LoadMapper
typedef struct 
{
	int MapperNum;
	WORD VersionLo;   // Low version number
	WORD VersionHi;   // High version number
	int BankSize;	  // Minimum granularity of the banks
	char *Name;
	char *Author;
} NESTENMAPPER;

// Function definitions for Load Mapper & Unload Mapper
typedef NESTENMAPPER* (*TLoadMapper)(int);
typedef void (*TUnloadMapper)(void);

// Array used for Mapper Info saving/Restoring
typedef void (*TSaveMI)(char*);
typedef void (*TLoadMI)(char*); 

// Function definitions for read write handlers
typedef void (*TWriteFunc)(int,int,int);
typedef int  (*TReadFunc)(int,int);

struct TMapperParam 
{
	// Flags
	BYTE Flag1;			// As found in the NES header file
	BYTE Flag2;			// As found in the NES header file
	BYTE HasCHR_ROM;	// 1 if there is CHR-ROM, else 0
	BYTE reserved;		// reserved ( assume to be 0 )
	
	// Procs for setting/getting write/read handlers
	void		(*SetWriteHandler)(int,TWriteFunc);
	void		(*SetReadHandler)(int, TReadFunc);
	TWriteFunc	(*GetWriteHandler)(int);
	TReadFunc	(*GetReadHandler)(int);
	
	// SetPRG's
	void(*SetPRG_67)(int);			//8K swap
	void(*SetPRG_89)(int);			//8K swap
	void(*SetPRG_AB)(int);			//8K swap
	void(*SetPRG_CD)(int);			//8K swap
	void(*SetPRG_EF)(int);			//8K swap
	void(*SetPRG_89AB)(int);		//16K swap
	void(*SetPRG_CDEF)(int);		//16K swap
	void(*SetPRG_89ABCDEF)(int);	//32K swap

	void(*SetPRG_Custom)(int,int,int);
	int (*GetPRG_Custom)(int,int); 
	
	// SetCHR's	
	void(*SetCHR_0000_03FF)(int);	// 1K swap
	void(*SetCHR_0400_07FF)(int);	// 1K swap
	void(*SetCHR_0800_0BFF)(int);	// 1K swap
	void(*SetCHR_0C00_0FFF)(int);	// 1K swap
	void(*SetCHR_1000_13FF)(int);	// 1K swap
	void(*SetCHR_1400_17FF)(int);	// 1K swap
	void(*SetCHR_1800_1BFF)(int);	// 1K swap
	void(*SetCHR_1C00_1FFF)(int);	// 1K swap	
	void(*SetCHR_0000_07FF)(int);	// 2k swap
	void(*SetCHR_0800_0FFF)(int);	// 2k swap
	void(*SetCHR_1000_17FF)(int);	// 2k swap
	void(*SetCHR_1800_1FFF)(int);	// 2k swap	
	void(*SetCHR_0000_0FFF)(int);	// 4k swap
	void(*SetCHR_1000_1FFF)(int);	// 4k swap
	void(*SetCHR_0000_1FFF)(int);	// 8k swap
	
	void(*SetCHR_Custom)(int,int,int);
	int (*GetCHR_Custom)(int,int);	
	void(*SetCHR_RAM)( int );
	
	// SetMirrors
	void(*Mirror_H)(void);				// Horizontal
	void(*Mirror_V)(void);				// Vertical
	void(*Mirror_4)(void);				// 4 Screen
	void(*Mirror_S0)(void);				// Single Low ( $2000 )
	void(*Mirror_S1)(void);				// Single High ( $2400 )
	void(*Mirror_Custom)( int,int,int,int );
	
	// External Sound chips
	void(*VRC6Write)(int,int,int);
	
	// Callback for debugging purposes
	void(*DbgOut)(char *);
};

// Function definition for Init Mapper
typedef void (*TInitMapper)(TMapperParam);

// Function definition for other
typedef int (*THBlank)(int,int);      // Returns 0 if no IRQ, 1 else
typedef int (*TTileHandler)(int,int); // Returns 0 if there was no change, 1 if change.

#endif