/*
 * Header file for NESten Mapper DLLs, version 1.1
 */

#ifndef __MINFO_H__
#define __MINFO_H__

#define CurrentMapperInterface 0x00010001

/* Function definitions */
typedef void (*PassS32)(int);
typedef void (*PassS32S32)(int,int);
typedef void (*PassS32S32S32)(int,int,int);
typedef void (*PassS32S32S32S32)(int,int,int,int);
typedef void (*PassNone)(void);
typedef void (*PassPChar)(char*);
typedef int  (*PassS32S32RS32)(int,int);

typedef void (*TWriteFunc)(int,int,int);
typedef int  (*TReadFunc)(int,int);

typedef void (*PassS32STW)(int,TWriteFunc);
typedef void (*PassS32STR)(int,TReadFunc);
typedef TWriteFunc (*PassS32RTW)(int);
typedef TReadFunc  (*PassS32RTR)(int);

/* The Info returned by the Mapper DLL on LoadMapper */
typedef struct {
	int MapperNum;
	short VersionLo;		/* Low version number */
	short VersionHi;		/* High version number */
	int BankSize;		/* Minimum granularity of the banks */
	char *Name;
	char *Author;
} NESTENMAPPER;

/* Function definitions for Load Mapper & Unload Mapper */

typedef NESTENMAPPER* (*TLoadMapper)(int);
typedef void (*TUnloadMapper)(void);

/* Array used for Mapper Info saving/Restoring */
typedef void (*TSaveMI)(char *);
typedef void (*TLoadMI)(char *); 

/* The Info passed to the Mapper DLL on InitMapper */
struct TMapperParam {
	unsigned char Flag1;		/* As found in the NES header file */
	unsigned char Flag2;
	unsigned char HasCHR_ROM;	/* 1 if there is CHR-ROM, else 0 */
	unsigned char unused;
	/* Procs for setting/getting write/read handlers */
	PassS32STW SetWriteHandler;
	PassS32STR SetReadHandler;
	PassS32RTW GetWriteHandler;
	PassS32RTR GetReadHandler;
	/* SetPRG's */
	PassS32 SetPRG_67;
	PassS32 SetPRG_89;
	PassS32 SetPRG_AB;
	PassS32 SetPRG_CD;
	PassS32 SetPRG_EF;
	PassS32 SetPRG_89AB;
	PassS32 SetPRG_CDEF;
	PassS32 SetPRG_89ABCDEF;
	PassS32S32S32 SetPRG_Custom;
	PassS32S32RS32 GetPRG_Custom; 
	/* SetCHR's */
	PassS32 SetCHR_0000_03FF;
	PassS32 SetCHR_0400_07FF;
	PassS32 SetCHR_0800_0BFF;
	PassS32 SetCHR_0C00_0FFF;
	PassS32 SetCHR_1000_13FF;
	PassS32 SetCHR_1400_17FF;
	PassS32 SetCHR_1800_1BFF;
	PassS32 SetCHR_1C00_1FFF;
	PassS32 SetCHR_0000_07FF;
	PassS32 SetCHR_0800_0FFF;
	PassS32 SetCHR_1000_17FF;
	PassS32 SetCHR_1800_1FFF;
	PassS32 SetCHR_0000_0FFF;
	PassS32 SetCHR_1000_1FFF;
	PassS32 SetCHR_0000_1FFF;
	PassS32S32S32 SetCHR_Custom;
	PassS32S32RS32 GetCHR_Custom;
	PassS32 SetCHR_RAM; 
	/* SetMirrors */
	void (*Mirror_H)();
	void (*Mirror_V)();
	void (*Mirror_4)();
	void (*Mirror_S0)();
	void (*Mirror_S1)();
	PassS32S32S32S32 Mirror_Custom;
	/* External Sound chips */
	PassS32S32S32 VRC6Write;
	/* Callback for debugging purposes */
	PassPChar DbgOut;
	PassS32 SetCHR_RAM_0000_03FF;
	PassS32 SetCHR_RAM_0400_07FF;
	PassS32 SetCHR_RAM_0800_0BFF;
	PassS32 SetCHR_RAM_0C00_0FFF;
	PassS32 SetCHR_RAM_1000_13FF;
	PassS32 SetCHR_RAM_1400_17FF;
	PassS32 SetCHR_RAM_1800_1BFF;
	PassS32 SetCHR_RAM_1C00_1FFF;
};

/* Function definition for Init Mapper */
typedef void (*TInitMapper)(TMapperParam);

/* Function definition for other */
typedef int (*THBlank)(int,int);	/* Returns 0 if no IRQ, 1 else */
typedef int (*TTileHandler)(int,int);	/* Returns 0 if there was no change, 1 if change. */

#endif
