#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"FFE F4xxx (partial)";

NESTENMAPPER mapper =
{
	6,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	16384,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;

void (*_PRG_Write_4)(int,int,int);
int IRQcounter, IRQenabled;

__declspec(dllexport) void SaveMI(char *MI)
{
	MI[0] = (IRQcounter & 0x00FF);
	MI[1] = (IRQcounter & 0xFF00) >> 8;
	MI[2] = IRQenabled;
}

__declspec(dllexport) void LoadMI(char *MI)
{
	IRQcounter = MI[0] + (MI[1] << 8);
	IRQenabled = MI[2];
}

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	/* Nothing */
}

__declspec(dllexport) void PRG_Write_4(int Bank, int Where, int What)
{
	if (Where < 0x018)
	{
		_PRG_Write_4(Bank,Where,What);
		return;
	}
	switch (Where)
	{
	case 0x2FC:
	case 0x2FD:
		/* ? */
		break;
	case 0x2FE:
		if (What & 0x10) MP.Mirror_S1();
		else MP.Mirror_S0();
		break;
	case 0x2FF:
		if (What & 0x10) MP.Mirror_H();
		else MP.Mirror_V();
		break;
	case 0x3FE:
	case 0x500:
		/* ? */
		break;
	case 0x501:
		IRQenabled = 0;
		break;
	case 0x502:
		IRQcounter = What;
		break;
	case 0x503:
	        IRQcounter += (What << 8);
		IRQenabled = 1;
		break;
	default:
		/* anything else? */
		break;
	}
}
__declspec(dllexport) void PRG_Write_89ABCDEF(int Bank, int Where, int What)
{
	MP.SetPRG_89AB((What & 0x3C) >> 2);
	MP.SetCHR_RAM(What & 0x3);
}

__declspec(dllexport) int HBlank(int Scanline, int Byte2001)
{
	if ((IRQenabled) && (IRQcounter))
	{
		IRQcounter += 114;
		if (IRQcounter > 0xFFFF)
		{
			IRQcounter = 0;
			return 1;
		}
	}
	return 0;
}

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
	int x;

	memcpy(&MP, MP_in, sizeof(struct TMapperParam));

	_PRG_Write_4 = MP.GetWriteHandler(0x4);
	MP.SetWriteHandler(0x4,PRG_Write_4);

	for (x = 0x8; x <= 0xF; x++)
		MP.SetWriteHandler(x,PRG_Write_89ABCDEF);

	MP.SetPRG_89AB(0);
	MP.SetPRG_CDEF(7);

	MP.SetCHR_RAM(0);

	if (MP.Flag1 & 0x08) MP.Mirror_4();
	else if (MP.Flag1 & 0x01) MP.Mirror_V();
	else MP.Mirror_H();
}
