#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"CPROM";

NESTENMAPPER mapper =
{
	13,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	32768,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;

__declspec(dllexport) void SaveMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) void LoadMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	/* Nothing */
}

__declspec(dllexport) void PRG_Write_89ABCDEF(int Bank, int Where, int What)
{
	MP.SetCHR_RAM_1000_13FF(((What & 0x3) << 2) + 0);
	MP.SetCHR_RAM_1400_17FF(((What & 0x3) << 2) + 1);
	MP.SetCHR_RAM_1800_1BFF(((What & 0x3) << 2) + 2);
	MP.SetCHR_RAM_1C00_1FFF(((What & 0x3) << 2) + 3);
	MP.SetPRG_89ABCDEF((What & 0x30) >> 4);
}

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
	int x;

	memcpy(&MP, MP_in, sizeof(struct TMapperParam));
	
	for (x = 0x8; x <= 0xF; x++)
		MP.SetWriteHandler(x,PRG_Write_89ABCDEF);

	MP.SetPRG_89ABCDEF(0);

	MP.SetCHR_RAM(0);

	if (MP.Flag1 & 0x08) MP.Mirror_4();
	else if (MP.Flag1 & 0x01) MP.Mirror_V();
	else MP.Mirror_H();
}
