#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"100-in-1 (partial)";

NESTENMAPPER mapper =
{
	15,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	8192,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;

__declspec(dllexport) void SaveMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) void LoadMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	/* Nothing */
}

__declspec(dllexport) void PRG_Write_8(int Bank, int Where, int What)
{
	int PRGbank = (What & 0x3F) << 1;
	switch (Where)
	{
	case 0x000:
		if (What & 0x80)
		{
			MP.SetPRG_89(PRGbank + 1);
			MP.SetPRG_AB(PRGbank + 0);
			MP.SetPRG_CD(PRGbank + 3);
			MP.SetPRG_EF(PRGbank + 2);
		}
		else
		{
			MP.SetPRG_89(PRGbank + 0);
			MP.SetPRG_AB(PRGbank + 1);
			MP.SetPRG_CD(PRGbank + 2);
			MP.SetPRG_EF(PRGbank + 3);
		}
		if (What & 0x40) MP.Mirror_H();
		else MP.Mirror_V();
		break;
	case 0x001:
		/* dunno what this should be doing */
		break;
	case 0x002:
		if (What & 0x80)
		{
			MP.SetPRG_89(PRGbank + 1);
			MP.SetPRG_AB(PRGbank + 1);
			MP.SetPRG_CD(PRGbank + 1);
			MP.SetPRG_EF(PRGbank + 1);
		}
		else
		{
			MP.SetPRG_89(PRGbank + 0);
			MP.SetPRG_AB(PRGbank + 0);
			MP.SetPRG_CD(PRGbank + 0);
			MP.SetPRG_EF(PRGbank + 0);
		}
		break;
	case 0x003:
		if (What & 0x80)
		{
			MP.SetPRG_CD(PRGbank + 1);
			MP.SetPRG_EF(PRGbank + 0);
		}
		else
		{
			MP.SetPRG_CD(PRGbank + 0);
			MP.SetPRG_EF(PRGbank + 1);
		}
		if (What & 0x40) MP.Mirror_H();
		else MP.Mirror_V();
		break;
	}
}

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
	memcpy(&MP, MP_in, sizeof(struct TMapperParam));

	MP.SetWriteHandler(0x8,PRG_Write_8);

	MP.SetPRG_89ABCDEF(0);

	MP.SetCHR_RAM(0);

	if (MP.Flag1 & 0x08) MP.Mirror_4();
	else if (MP.Flag1 & 0x01) MP.Mirror_V();
	else MP.Mirror_H();
}