#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"Tengen RAMBO-1 (partial)";

NESTENMAPPER mapper =
{
	64,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	32768,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;

int Cmd, Prg, Chr;

__declspec(dllexport) void SaveMI(char *MI)
{
	MI[0] = Cmd;
	MI[1] = Prg;
	MI[2] = Chr;
}

__declspec(dllexport) void LoadMI(char *MI)
{
	Cmd = MI[0];
	Prg = MI[1];
	Chr = MI[2];
}

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	/* Nothing */
}

__declspec(dllexport) void PRG_Write_8(int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0:
		Cmd = What & 0x0F;
		Prg = (What & 0x40) >> 6;
		Chr = (What & 0x80) >> 7;
		break;
	case 1:
		switch (Cmd)
		{
		case 0x0:
			if (Chr)
			{
				MP.SetCHR_1000_13FF(What);
				MP.SetCHR_1400_17FF(What + 1);
			}
			else
			{
				MP.SetCHR_0000_03FF(What);
				MP.SetCHR_0400_07FF(What + 1);
			}
			break;
		case 0x1:
			if (Chr)
			{
				MP.SetCHR_1800_1BFF(What);
				MP.SetCHR_1C00_1FFF(What + 1);
			}
			else
			{
				MP.SetCHR_0800_0BFF(What);
				MP.SetCHR_0C00_0FFF(What + 1);
			}
			break;
		case 0x2:
			if (Chr) MP.SetCHR_0000_03FF(What);
			else MP.SetCHR_1000_13FF(What);
			break;
		case 0x3:
			if (Chr) MP.SetCHR_0400_07FF(What);
			else MP.SetCHR_1400_17FF(What);
			break;
		case 0x4:
			if (Chr) MP.SetCHR_0800_0BFF(What);
			else MP.SetCHR_1800_1BFF(What);
			break;
		case 0x5:
			if (Chr) MP.SetCHR_0C00_0FFF(What);
			else MP.SetCHR_1C00_1FFF(What);
			break;
		case 0x6:
			if (Prg) MP.SetPRG_AB(What);
			else MP.SetPRG_89(What);
			break;
		case 0x7:
			if (Prg) MP.SetPRG_CD(What);
			else MP.SetPRG_AB(What);
			break;
		case 0x8:
			MP.SetCHR_0400_07FF(What);
			break;
		case 0x9:
			MP.SetCHR_0C00_0FFF(What);
			break;
		case 0xF:
			if (Prg) MP.SetPRG_89(What);
			else MP.SetPRG_CD(What);
			break;
		}
		break;
	}
}

__declspec(dllexport) void PRG_Write_A(int Bank, int Where, int What)
{
	if (What & 0x1) MP.Mirror_V();
	else MP.Mirror_H();
}

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
	memcpy(&MP, MP_in, sizeof(struct TMapperParam));

	MP.SetWriteHandler(0x8,PRG_Write_8);
	MP.SetWriteHandler(0xA,PRG_Write_A);

	MP.SetPRG_89(-1);
	MP.SetPRG_AB(-1);
	MP.SetPRG_CD(-1);
	MP.SetPRG_EF(-1);

	MP.SetCHR_0000_1FFF(0);
	/* Mapper controls mirroring */
}
