#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"GNROM";

NESTENMAPPER mapper =
{
	66,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	32768,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;

__declspec(dllexport) void SaveMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) void LoadMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	/* Nothing */
}

__declspec(dllexport) void PRG_Write_6789ABCDEF(int Bank, int Where, int What)
{
	MP.SetPRG_89ABCDEF((What & 0xF0) >> 4);
	MP.SetCHR_0000_1FFF(What & 0x0F);
}

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
	int x;

	memcpy(&MP, MP_in, sizeof(struct TMapperParam));

	for (x = 0x6; x <= 0xF; x++)
		MP.SetWriteHandler(x,PRG_Write_6789ABCDEF);

	MP.SetPRG_89ABCDEF(0);

	MP.SetCHR_0000_1FFF(0);

	if (MP.Flag1 & 0x08) MP.Mirror_4();
	else if (MP.Flag1 & 0x01) MP.Mirror_V();
	else MP.Mirror_H();
}
