#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"Sunsoft Mapper #4 (partial)";

NESTENMAPPER mapper =
{
	68,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	8192,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;

int Mirror;

__declspec(dllexport) void SaveMI(char *MI)
{
	MI[0] = Mirror;
}

__declspec(dllexport) void LoadMI(char *MI)
{
	Mirror = MI[0];
}

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	/* Nothing */
}

__declspec(dllexport) void PRG_Write_8(int Bank, int Where, int What)
{
	MP.SetCHR_0000_07FF(What);
}

__declspec(dllexport) void PRG_Write_9(int Bank, int Where, int What)
{
	MP.SetCHR_0800_0FFF(What);
}

__declspec(dllexport) void PRG_Write_A(int Bank, int Where, int What)
{
	MP.SetCHR_1000_17FF(What);
}

__declspec(dllexport) void PRG_Write_B(int Bank, int Where, int What)
{
	MP.SetCHR_1800_1FFF(What);
}

__declspec(dllexport) void PRG_Write_C(int Bank, int Where, int What)
{
	MP.Mirror_S0();
	MP.SetCHR_Custom(0x10,What,1024);
	switch (Mirror)
	{
	case 0:	MP.Mirror_V();		break;
	case 1:	MP.Mirror_H();		break;
	case 2:	MP.Mirror_S0();		break;
	case 3:	MP.Mirror_S1();		break;
	}
}

__declspec(dllexport) void PRG_Write_D(int Bank, int Where, int What)
{
	MP.Mirror_S1();
	MP.SetCHR_Custom(0x10,What,1024);
	switch (Mirror)
	{
	case 0:	MP.Mirror_V();		break;
	case 1:	MP.Mirror_H();		break;
	case 2:	MP.Mirror_S0();		break;
	case 3:	MP.Mirror_S1();		break;
	}
}

__declspec(dllexport) void PRG_Write_E(int Bank, int Where, int What)
{
	switch (What & 0x3)
	{
	case 0:	MP.Mirror_V();		break;
	case 1:	MP.Mirror_H();		break;
	case 2:	MP.Mirror_S0();		break;
	case 3:	MP.Mirror_S1();		break;
	}
	Mirror = What & 0x3;
	if (What & 0x10) { /* MP.DbgOut("CHR_ROM for Nametable enabled"); */ }
	else { /* MP.DbgOut("CHR_ROM for Nametable disabled"); */ }
}

__declspec(dllexport) void PRG_Write_F(int Bank, int Where, int What)
{
	MP.SetPRG_89AB(What);
}

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
	memcpy(&MP, MP_in, sizeof(struct TMapperParam));

	MP.SetWriteHandler(0x8,PRG_Write_8);
	MP.SetWriteHandler(0x9,PRG_Write_9);
	MP.SetWriteHandler(0xA,PRG_Write_A);
	MP.SetWriteHandler(0xB,PRG_Write_B);
	MP.SetWriteHandler(0xC,PRG_Write_C);
	MP.SetWriteHandler(0xD,PRG_Write_D);
	MP.SetWriteHandler(0xE,PRG_Write_E);
	MP.SetWriteHandler(0xF,PRG_Write_F);

	MP.SetPRG_89AB(0);
	MP.SetPRG_CDEF(-1);

	MP.SetCHR_0000_1FFF(0);

	if (MP.Flag1 & 0x08) MP.Mirror_4();
	else if (MP.Flag1 & 0x01) MP.Mirror_V();
	else MP.Mirror_H();
}
