#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"Sunsoft FME-7";

NESTENMAPPER mapper =
{
	69,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	8192,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;

int Cmd, IRQenabled, IRQcounter;

__declspec(dllexport) void SaveMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) void LoadMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	/* Nothing */
}

__declspec(dllexport) void PRG_Write_8(int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0x000:	Cmd = What & 0xF;		break;
	}
}

__declspec(dllexport) void PRG_Write_A(int Bank, int Where, int What)
{
	switch (Cmd)
	{
	case 0x0:	MP.SetCHR_0000_03FF(What);	break;
	case 0x1:	MP.SetCHR_0400_07FF(What);	break;
	case 0x2:	MP.SetCHR_0800_0BFF(What);	break;
	case 0x3:	MP.SetCHR_0C00_0FFF(What);	break;
	case 0x4:	MP.SetCHR_1000_13FF(What);	break;
	case 0x5:	MP.SetCHR_1400_17FF(What);	break;
	case 0x6:	MP.SetCHR_1800_1BFF(What);	break;
	case 0x7:	MP.SetCHR_1C00_1FFF(What);	break;
	case 0x8:
		if (What & 0x40)
		{
			if (What & 0x80) { /* SRAM */ }
			else { /* garbage */ }

		}
		else MP.SetPRG_67(What);		break;
	case 0x9:	MP.SetPRG_89(What);		break;
	case 0xA:	MP.SetPRG_AB(What);		break;
	case 0xB:	MP.SetPRG_CD(What);		break;
	case 0xC:
		switch (What & 0x03)
		{
		case 0:	MP.Mirror_V();				break;
		case 1:	MP.Mirror_H();				break;
		case 2:	MP.Mirror_S0();				break;
		case 3:	MP.Mirror_S1();				break;
		}					break;
	case 0xD:	IRQenabled = What;		break;
	case 0xE:	IRQcounter = (IRQcounter & 0xFF00)
				| (What << 0);		break;
	case 0xF:	IRQcounter = (IRQcounter & 0x00FF)
				| (What << 8);		break;
	}
}

__declspec(dllexport) int HBlank(int Scanline, int Byte2001)
{
	if (IRQenabled)
	{
		IRQcounter = IRQcounter - 114;
		if (IRQcounter < 1) return 1;
	}
	return 0;
}

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
	memcpy(&MP, MP_in, sizeof(struct TMapperParam));

	MP.SetWriteHandler(0x8,PRG_Write_8);
	MP.SetWriteHandler(0xA,PRG_Write_A);

	MP.SetPRG_89AB(0);
	MP.SetPRG_CDEF(-1);

	if (MP.HasCHR_ROM) MP.SetCHR_0000_1FFF(0);
	else MP.SetCHR_RAM(0);

	if (MP.Flag1 & 0x08) MP.Mirror_4();
	else if (MP.Flag1 & 0x01) MP.Mirror_V();
	else MP.Mirror_H();
}
