#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"Camerica (partial)";

NESTENMAPPER mapper =
{
	71,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	16384,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;

__declspec(dllexport) void SaveMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) void LoadMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	/* Nothing */
}

__declspec(dllexport) void PRG_Write_67CDEF(int Bank, int Where, int What)
{
	MP.SetPRG_89AB(What);
}

__declspec(dllexport) void PRG_Write_89AB(int Bank, int Where, int What)
{
	/* No idea */
}

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
	int x;

	memcpy(&MP, MP_in, sizeof(struct TMapperParam));

	for (x = 0x6; x <= 0x7; x++)
		MP.SetWriteHandler(x,PRG_Write_67CDEF);
	for (x = 0x8; x <= 0xB; x++)
		MP.SetWriteHandler(x,PRG_Write_89AB);
	for (x = 0xC; x <= 0xF; x++)
		MP.SetWriteHandler(x,PRG_Write_67CDEF);

	MP.SetPRG_89AB(0);
	MP.SetPRG_CDEF(-1);

	MP.SetCHR_RAM(0);

	if (MP.Flag1 & 0x08) MP.Mirror_4();
	else if (MP.Flag1 & 0x01) MP.Mirror_V();
	else MP.Mirror_H();
}
