#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"Irem 74HC161/32";

NESTENMAPPER mapper =
{
	78,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	16384,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;
int Mirror;

__declspec(dllexport) void SaveMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) void LoadMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	/* Nothing */
}

__declspec(dllexport) void PRG_Write_89ABCDEF(int Bank, int Where, int What)
{
	MP.SetCHR_0000_1FFF((What & 0xF0) >> 4);
	MP.SetPRG_89AB(What & 0x7);
	if (Mirror)
	{
		if (What & 0x8) MP.Mirror_V();
		else MP.Mirror_H();
	}
	else
	{
		if (What & 0x8) MP.Mirror_S1();
		else MP.Mirror_S0();
	}
}

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
	int x;

	memcpy(&MP, MP_in, sizeof(struct TMapperParam));

	for (x = 0x8; x <= 0xF; x++)
		MP.SetWriteHandler(x,PRG_Write_89ABCDEF);

	MP.SetPRG_89AB(0);
	MP.SetPRG_CDEF(-1);

	MP.SetCHR_0000_1FFF(0);

	/* This is a screwy mapper - if 4-screen mirroring is set, mirroring
	 * toggle in register write swaps between vertical and horizontal
	 * mirroring.  If not, swaps between screen1 and screen0 mirroring.
	 * This should have been 2 separate mappers.
	 */
	if (MP.Flag1 & 0x08) Mirror = 1;
	else Mirror = 0;
}