#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"NINA-03/NINA-06";

NESTENMAPPER mapper =
{
	79,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	16384,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;

void (*_PRG_Write_4)(int,int,int);

__declspec(dllexport) void SaveMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) void LoadMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	/* Nothing */
}

__declspec(dllexport) void PRG_Write_45(int Bank, int Where, int What)
{
	if (Where & 0x100)
	{
		MP.SetCHR_0000_1FFF(What & 0x7);
		MP.SetPRG_89ABCDEF((What & 0x8) >> 3);
	}
	if (Bank == 4) _PRG_Write_4(Bank,Where,What);
}

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
	int x;

	memcpy(&MP, MP_in, sizeof(struct TMapperParam));

	_PRG_Write_4 = MP.GetWriteHandler(0x4);

	for (x = 0x4; x <= 0x5; x++)
		MP.SetWriteHandler(x,PRG_Write_45);

	MP.SetPRG_89ABCDEF(0);

	MP.SetCHR_0000_1FFF(0);

	if (MP.Flag1 & 0x08) MP.Mirror_4();
	else if (MP.Flag1 & 0x01) MP.Mirror_V();
	else MP.Mirror_H();
}
