#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"
#include "vrc7.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"Konami VRC7";

NESTENMAPPER mapper =
{
	85,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	8192,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;

int IRQcount, IRQlatch, IRQtoggle, IRQenabled, SNDreg;

__declspec(dllexport) void SaveMI(char *MI)
{
	MI[0] = IRQcount;
	MI[1] = IRQlatch;
	MI[2] = IRQtoggle;
	MI[3] = IRQenabled;
	MI[4] = SNDreg;
	/* Custom instrument registers */
	MI[5] = Instrument[0][0];
	MI[6] = Instrument[0][1];
	MI[7] = Instrument[0][2];
	MI[8] = Instrument[0][3];
	MI[9] = Instrument[0][4];
	MI[10] = Instrument[0][5];
	MI[11] = Instrument[0][6];
	MI[12] = Instrument[0][7];
	/* Registers for each sound channel */
	MI[13] = SoundInfo[0][0];
	MI[14] = SoundInfo[0][1];
	MI[15] = SoundInfo[0][2];
	MI[16] = SoundInfo[0][3];
	MI[17] = SoundInfo[0][4];
	MI[18] = SoundInfo[0][5];
	MI[19] = SoundInfo[1][0];
	MI[20] = SoundInfo[1][1];
	MI[21] = SoundInfo[1][2];
	MI[22] = SoundInfo[1][3];
	MI[23] = SoundInfo[1][4];
	MI[24] = SoundInfo[1][5];
	MI[25] = SoundInfo[2][0];
	MI[26] = SoundInfo[2][1];
	MI[27] = SoundInfo[2][2];
	MI[28] = SoundInfo[2][3];
	MI[29] = SoundInfo[2][4];
	MI[30] = SoundInfo[2][5];
}

__declspec(dllexport) void LoadMI(char *MI)
{
	IRQcount = MI[0];
	IRQlatch = MI[1];
	IRQtoggle = MI[2];
	IRQenabled = MI[3];
	SNDreg = MI[4];
	/* Custom instrument registers */
	Instrument[0][0] = MI[5];
	Instrument[0][1] = MI[6];
	Instrument[0][2] = MI[7];
	Instrument[0][3] = MI[8];
	Instrument[0][4] = MI[9];
	Instrument[0][5] = MI[10];
	Instrument[0][6] = MI[11];
	Instrument[0][7] = MI[12];
	/* Registers for each sound channel */
	SoundInfo[0][0] = MI[13];
	SoundInfo[0][1] = MI[14];
	SoundInfo[0][2] = MI[15];
	SoundInfo[0][3] = MI[16];
	SoundInfo[0][4] = MI[17];
	SoundInfo[0][5] = MI[18];
	SoundInfo[1][0] = MI[19];
	SoundInfo[1][1] = MI[20];
	SoundInfo[1][2] = MI[21];
	SoundInfo[1][3] = MI[22];
	SoundInfo[1][4] = MI[23];
	SoundInfo[1][5] = MI[24];
	SoundInfo[2][0] = MI[25];
	SoundInfo[2][1] = MI[26];
	SoundInfo[2][2] = MI[27];
	SoundInfo[2][3] = MI[28];
	SoundInfo[2][4] = MI[29];
	SoundInfo[2][5] = MI[30];
}

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	ClearOPL2();
	CheckOPL2();
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	ClearOPL2();
}

__declspec(dllexport) void PRG_Write_8(int Bank, int Where, int What)
{
	switch ((Where & 0x10) | ((Where & 0x8) << 1))
	{
	case 0x000:
		MP.SetPRG_89(What);
		break;
	case 0x010:
		MP.SetPRG_AB(What);
		break;
	}
}

__declspec(dllexport) void PRG_Write_9(int Bank, int Where, int What)
{
	switch (Where & 0x30)
	{
	case 0x000:
		MP.SetPRG_CD(What);
		break;
	case 0x010:
		SNDreg = What;
		break;
	case 0x030:
		VRC7_dosound(SNDreg,What);
		break;
	}
}

__declspec(dllexport) void PRG_Write_A(int Bank, int Where, int What)
{
	switch ((Where & 0x10) | ((Where & 0x8) << 1))
	{
	case 0x000:
		if (MP.HasCHR_ROM) MP.SetCHR_0000_03FF(What);
		else MP.SetCHR_RAM_0000_03FF(What);
		break;
	case 0x010:
		if (MP.HasCHR_ROM) MP.SetCHR_0400_07FF(What);
		else MP.SetCHR_RAM_0400_07FF(What);
		break;
	}
}

__declspec(dllexport) void PRG_Write_B(int Bank, int Where, int What)
{
	switch ((Where & 0x10) | ((Where & 0x8) << 1))
	{
	case 0x000:
		if (MP.HasCHR_ROM) MP.SetCHR_0800_0BFF(What);
		else MP.SetCHR_RAM_0800_0BFF(What);
		break;
	case 0x010:
		if (MP.HasCHR_ROM) MP.SetCHR_0C00_0FFF(What);
		else MP.SetCHR_RAM_0C00_0FFF(What);
		break;
	}
}

__declspec(dllexport) void PRG_Write_C(int Bank, int Where, int What)
{
	switch ((Where & 0x10) | ((Where & 0x8) << 1))
	{
	case 0x000:
		if (MP.HasCHR_ROM) MP.SetCHR_1000_13FF(What);
		else MP.SetCHR_RAM_1000_13FF(What);
		break;
	case 0x010:
		if (MP.HasCHR_ROM) MP.SetCHR_1400_17FF(What);
		else MP.SetCHR_RAM_1400_17FF(What);
		break;
	}
}

__declspec(dllexport) void PRG_Write_D(int Bank, int Where, int What)
{
	switch ((Where & 0x10) | ((Where & 0x8) << 1))
	{
	case 0x000:
		if (MP.HasCHR_ROM) MP.SetCHR_1800_1BFF(What);
		else MP.SetCHR_RAM_1800_1BFF(What);
		break;
	case 0x010:
		if (MP.HasCHR_ROM) MP.SetCHR_1C00_1FFF(What);
		else MP.SetCHR_RAM_1C00_1FFF(What);
		break;
	}
}

__declspec(dllexport) void PRG_Write_E(int Bank, int Where, int What)
{
	switch ((Where & 0x10) | ((Where & 0x8) << 1))
	{
	case 0x000:
		switch (What & 0x3)
		{
		case 0:
			MP.Mirror_V();
			break;
		case 1:
			MP.Mirror_H();
			break;
		case 2:
			MP.Mirror_S0();
			break;
		case 3:
			MP.Mirror_S1();
			break;
		}
		break;
	case 0x010:
		IRQlatch = What;
		break;
	}
}

__declspec(dllexport) void PRG_Write_F(int Bank, int Where, int What)
{
	switch ((Where & 0x10) | ((Where & 0x8) << 1))
	{
	case 0x000:
		IRQtoggle = What & 0x01;
		IRQenabled = What & 0x02;
		if (IRQenabled) IRQcount = IRQlatch;
		break;
	case 0x010:
		IRQenabled = IRQtoggle;
		break;
	}
}

__declspec(dllexport) int HBlank(int Scanline, int Byte2001)
{
	if (IRQenabled)
	{
		if (IRQcount > 0xFF)
		{
			IRQcount = IRQlatch;
			return 1;
		}
		IRQcount++;
	}
	return 0;
}

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
	memcpy(&MP, MP_in, sizeof(struct TMapperParam));

	MP.SetWriteHandler(0x8,PRG_Write_8);
	MP.SetWriteHandler(0x9,PRG_Write_9);
	MP.SetWriteHandler(0xA,PRG_Write_A);
	MP.SetWriteHandler(0xB,PRG_Write_B);
	MP.SetWriteHandler(0xC,PRG_Write_C);
	MP.SetWriteHandler(0xD,PRG_Write_D);
	MP.SetWriteHandler(0xE,PRG_Write_E);
	MP.SetWriteHandler(0xF,PRG_Write_F);

	MP.SetPRG_89AB(0);
	MP.SetPRG_CDEF(-1);

	if (MP.HasCHR_ROM) MP.SetCHR_0000_1FFF(0);
	else MP.SetCHR_RAM(0);

	/* Mapper controls mirroring */
}