#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"VS Unisystem (partial)";

NESTENMAPPER mapper =
{
	99,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	32768,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;

void (*_PRG_Write_4)(int,int,int);
int (*_PRG_Read_4)(int,int);

__declspec(dllexport) void SaveMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) void LoadMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	/* Nothing */
}

__declspec(dllexport) void PRG_Write_4(int Bank, int Where, int What)
{
	if (Where == 0x016)
	{
		if (What & 0x04) MP.SetCHR_0000_1FFF(1);
		else MP.SetCHR_0000_1FFF(0);
	}
	_PRG_Write_4(Bank,Where,What);
}

__declspec(dllexport) int PRG_Read_4(int Bank, int Where)
{
	return _PRG_Read_4(Bank,Where);
}

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
	memcpy(&MP, MP_in, sizeof(struct TMapperParam));

	_PRG_Write_4 = MP.GetWriteHandler(0x4);
	MP.SetWriteHandler(0x4,PRG_Write_4);
	_PRG_Read_4 = MP.GetReadHandler(0x4);
	MP.SetReadHandler(0x4,PRG_Read_4);

	MP.SetPRG_89ABCDEF(0);

	MP.SetCHR_0000_1FFF(0);

	MP.Mirror_4();
}
