#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"Mapper 184 (bad)";

NESTENMAPPER mapper =
{
	184,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	16384,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;

__declspec(dllexport) void SaveMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) void LoadMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	/* Nothing */
}

__declspec(dllexport) void PRG_Write_6(int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0x000:
		/* This is wrong */
		MP.SetCHR_1000_17FF(What & 0x0F);
		break;
	default:
		break;
	}
}

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
	memcpy(&MP, MP_in, sizeof(struct TMapperParam));

	MP.SetWriteHandler(6,PRG_Write_6);

	MP.SetPRG_89AB(0);
	MP.SetPRG_CDEF(-1);

	if (MP.HasCHR_ROM) MP.SetCHR_0000_1FFF(0);
	else MP.SetCHR_RAM(0);

	if (MP.Flag1 & 0x08) MP.Mirror_4();
	else if (MP.Flag1 & 0x01) MP.Mirror_V();
	else MP.Mirror_H();
}
