#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"1200-in-1 (partial)";

NESTENMAPPER mapper =
{
	227,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	16384,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;

/* int CHRprotect = 0, VRAMaddr = 0, VRAMnum = 0;

void (*_PRG_Write_2)(int,int,int);
void (*_PRG_Write_3)(int,int,int); */

__declspec(dllexport) void SaveMI(char *MI)
{
/*	MI[0] = CHRprotect;
	MI[1] = (VRAMaddr & 0x00FF) >> 0;
	MI[2] = (VRAMaddr & 0xFF00) >> 8;
	MI[3] = VRAMnum; */
}

__declspec(dllexport) void LoadMI(char *MI)
{
/*	CHRprotect = MI[0];
	VRAMaddr = MI[1] | (MI[2] << 8);
	VRAMnum = MI[3]; */
}

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	/* Nothing */
}

__declspec(dllexport) void PRG_Write_89ABCDEF(int Bank, int Where, int What)
{
	int PRGbank = ((Where & 0x100) >> 4) | ((Where & 0x78) >> 3);
	if (Where & 0x2) MP.Mirror_H();
	else MP.Mirror_V();
	if (Where & 0x1) 
	{
		MP.SetPRG_89ABCDEF(PRGbank);
	}
	else
	{
		if ((Where & 0x4) >> 2)
		{
			MP.SetPRG_89AB((PRGbank << 1) + 1);
			MP.SetPRG_CDEF((PRGbank << 1) + 1);
		}
		else
		{
			MP.SetPRG_89AB((PRGbank << 1) + 0);
			MP.SetPRG_CDEF((PRGbank << 1) + 0);
		}
	}
	if (Where & 0x80)
	{
/*		CHRprotect = 1; */
	}
	else
	{
/*		CHRprotect = 0; */
		if (Where & 0x200) MP.SetPRG_CDEF(((PRGbank & 0x1C) << 1) + 7);
		else MP.SetPRG_CDEF(((PRGbank & 0x1C) << 1) + 0);
	}
}

/* __declspec(dllexport) void PRG_Write_23(int Bank, int Where, int What)
{
	if (CHRprotect == 1)
	{
		if ((Where & 0x007) == 0x005)
		{
			if (VRAMnum == 0)
			{
				VRAMaddr = What;
				VRAMnum = 1;
			}
			else
			{
				VRAMaddr = VRAMaddr | (What << 8);
				VRAMnum = 0;
			}
		}
		else if ((Where & 0x007) == 0x007)
		{
			if (VRAMaddr < 0x2000) return;
		}
	}
	if (Bank == 0x2) _PRG_Write_2(Bank,Where,What);
	else _PRG_Write_3(Bank,Where,What);
} */

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
 	int x;

	memcpy(&MP, MP_in, sizeof(struct TMapperParam));

/*	_PRG_Write_2 = MP.GetWriteHandler(0x2);
 	_PRG_Write_3 = MP.GetWriteHandler(0x3);

	for (x = 0x2; x <= 0x3; x++)
		MP.SetWriteHandler(x,PRG_Write_23); */

	for (x = 0x8; x <= 0xF; x++)
		MP.SetWriteHandler(x,PRG_Write_89ABCDEF);

	MP.SetPRG_89AB(0);
	MP.SetPRG_CDEF(0);

	MP.SetCHR_RAM(0);

	/* Mapper controls mirroring */
}
