#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"Action 52";

NESTENMAPPER mapper =
{
	228,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	16384,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;

__declspec(dllexport) void SaveMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) void LoadMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	/* Nothing */
}

__declspec(dllexport) void PRG_Write_89ABCDEF(int Bank, int Where, int What)
{
	int Loc, PRGbank;
	Loc = Bank * 0x1000 + Where;
	PRGbank = (Loc & 0x780) >> 7;
	if (Loc & 0x2000) MP.Mirror_H();
	else MP.Mirror_V();
	switch ((Loc & 0x1800) >> 11)
	{
	case 0:
		break;
	case 1:
		PRGbank = PRGbank | 0x10;
		break;
	case 2:
		/* should return garbage */
		break;
	case 3:
		PRGbank = PRGbank | 0x20;
		break;
	}
	if (Loc & 0x20)
	{
		PRGbank = PRGbank << 1;
		if (Loc & 0x40) PRGbank++;
		MP.SetPRG_89AB(PRGbank << 1);
		MP.SetPRG_CDEF(PRGbank << 1);
	}
	else MP.SetPRG_89ABCDEF(PRGbank);
	MP.SetCHR_0000_1FFF(((Loc & 0xF) << 2) | (What & 0x3));
}

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
	int x;

	memcpy(&MP, MP_in, sizeof(struct TMapperParam));

	for (x = 0x8; x <= 0xF; x++)
		MP.SetWriteHandler(x,PRG_Write_89ABCDEF);

	MP.SetPRG_89ABCDEF(0);
	MP.SetCHR_0000_1FFF(0);
	/* Mapper controls mirroring */
}
