#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"31-in-1";

NESTENMAPPER mapper =
{
	229,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	16384,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;

__declspec(dllexport) void SaveMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) void LoadMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	/* Nothing */
}

__declspec(dllexport) void PRG_Write_89ABCDEF(int Bank, int Where, int What)
{
	if (!(Where & 0x1E))
	{
		MP.SetPRG_89ABCDEF(0);
		MP.SetCHR_0000_1FFF(0);
	}
	else
	{
		MP.SetPRG_89AB(Where & 0x1F);
		MP.SetPRG_CDEF(Where & 0x1F);
		MP.SetCHR_0000_1FFF(Where);
	}
	if (Where & 0x20) MP.Mirror_H();
	else MP.Mirror_V();
}

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
	int x;

	memcpy(&MP, MP_in, sizeof(struct TMapperParam));

	for (x = 0x8; x <= 0xF; x++)
		MP.SetWriteHandler(x,PRG_Write_89ABCDEF);

	MP.SetPRG_89ABCDEF(0);

	MP.SetCHR_0000_1FFF(0);

	/* Mapper controls mirroring */
}
