#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include "mapper.h"
#include "vrc7.h"

char	author[] =	"The Quietust <quietust@ircN.org>";
char    name[] =	"NSF mapper";

NESTENMAPPER mapper =
{
	666,	/* *** Mapper Number *** */
	0,	/* Version number (low) ?.0 */
	1,	/* Version number (high) 1.? */
	8192,	/* *** PRG Bank Size *** */
	name,	/* mapper name */
	author	/* me */
};

struct TMapperParam MP;

__declspec(dllexport) void SaveMI(char *MI)
{
	/* Nothing */
}

__declspec(dllexport) void LoadMI(char *MI)
{
	/* Nothing */
}

int SNDreg;

__declspec(dllexport) NESTENMAPPER *LoadMapper(int VersionNeeded)
{
	ClearOPL2();
	CheckOPL2();
	if (VersionNeeded > CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!",name,0);
		return NULL;
	}
	else return &mapper;
}

__declspec(dllexport) void UnloadMapper(void)
{
	ClearOPL2();
}

__declspec(dllexport) void PRG_Write_5(int Bank, int Where, int What)
{
	if (Where >= 0xFF8) MP.SetPRG_Custom(Where & 0xF,What,4096);
}

__declspec(dllexport) void PRG_Write_9(int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0x000:
	case 0x001:
	case 0x002:
		MP.VRC6Write(0,Where,What);
		break;
	case 0x010:
		SNDreg = What;
		break;
	case 0x030:
		VRC7_dosound(SNDreg,What);
		break;
	}
}

__declspec(dllexport) void PRG_Write_A(int Bank, int Where, int What)
{
	MP.VRC6Write(1,Where,What);
}

__declspec(dllexport) void PRG_Write_B(int Bank, int Where, int What)
{
	MP.VRC6Write(2,Where,What);
}

__declspec(dllexport) void InitMapper(struct TMapperParam *MP_in)
{
	memcpy(&MP, MP_in, sizeof(struct TMapperParam));

	MP.SetWriteHandler(0x5,PRG_Write_5);
	MP.SetReadHandler(0x5,MP.GetReadHandler(0x8));

	MP.SetWriteHandler(0x9,PRG_Write_9);
	MP.SetWriteHandler(0xA,PRG_Write_A);
	MP.SetWriteHandler(0xB,PRG_Write_B);

	MP.SetCHR_RAM(0);
}