#include "vrc7.h"

int IsOPL2 = 0;
unsigned char Instrument[16][8] = {
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x31,0x22,0x23,0x07,0xF0,0xF0,0xE8,0xF7},
	{0x03,0x31,0x68,0x05,0xF2,0x74,0x79,0x9C},
	{0x01,0x51,0x72,0x04,0xF1,0xD3,0x9D,0x8B},
	{0x22,0x61,0x1B,0x05,0xC0,0xA1,0xF8,0xE8},
	{0x22,0x61,0x2C,0x03,0xD2,0xA1,0xA7,0xE8},
	{0x31,0x22,0xFA,0x01,0xF1,0xF1,0xF4,0xEE},
	{0x21,0x61,0x28,0x06,0xF1,0xF1,0xCE,0x9B},
	{0x27,0x61,0x60,0x00,0xF0,0xF0,0xFF,0xFD},
	{0x60,0x21,0x2B,0x06,0x85,0xF1,0x79,0x9D},
	{0x31,0xA1,0xFF,0x0A,0x53,0x62,0x5E,0xAF},

/*	{0x03,0xA1,0x70,0x0F,0xD4,0xA3,0x94,0xBE}, */
/*	  00000011, 10100001, 01110000, 00001111, 11010100, 10100011, 10010100, 10111110 */
/*	  00000111, 10000001, 00101011, 00000101, 10100101, 10100101, 00000011, 00000011 */
	 
	/* Modulator multiplier increased from 3 to 7
	 * Carrier sustain dropped
	 * Modulator key scale level decreased from 1 to 0
	 * Modulator output level dropped from 48 to 43
	 * Modulator waveform switched from rectified sine to sine
	 * Feedback decreased from 7 to 3
	 * Modulator attack dropped from 13 to 10
	 * Modulator decay increased from 4 to 5
	 * Carrier decay increased from 3 to 5
	 * Modulator sustain dropped from 9 to 0
	 * Modulator release dropped from 4 to 3
	 * Carrier sustain dropped from 11 to 0
	 * Carrier release dropped from 14 to 3
	 */
	{0x07,0x81,0x2B,0x05,0xA5,0xA5,0x03,0x03},

	{0x2B,0x61,0xE4,0x07,0xF6,0x93,0xBD,0xAC},
	{0x21,0x63,0xED,0x07,0x77,0xF1,0xC7,0xE8},
	{0x21,0x61,0x2A,0x03,0xF3,0xE2,0xB6,0xD9},
	{0x21,0x63,0x37,0x03,0xF3,0xE2,0xB6,0xD9}
};

unsigned char InstTrans[6] = { 0x00,0x01,0x02,0x08,0x09,0x0A };

void OPL2_setreg (unsigned short reg, int value)
{
	int i;
	_outp(0x388,reg);
	
	for (i = 0; i < 6; i++)
		_inp(0x388);

	_outp(0x389,value);
	
	for (i = 0; i < 35; i++)
		_inp(0x388);
}

int CheckOPL2 (void)
{
	int i;
	char status1, status2;

	OPL2_setreg(4,0x60);
	OPL2_setreg(4,0x80);

	status1 = _inp(0x388);

	OPL2_setreg(2,0xFF);
	OPL2_setreg(4,0x21);

	for (i = 0; i < 125; i++) 
		_inp(0x388);

	status2 = _inp(0x388);
	
	OPL2_setreg(4,0x60);
	OPL2_setreg(4,0x80);

	IsOPL2 = 0;
	if (((status1 & 0xE0) == 0) && ((status2 & 0xE0) == 0xC0))
		IsOPL2 = 1;
	return IsOPL2;
}

void ClearOPL2 (void)
{
	short x;
	for (x = 0; x < 256; x++)
		OPL2_setreg(x,0);
}

void VRC7_dosound (unsigned short Reg, int Value)
{
	unsigned char x = Reg & 0x0F, y;
	switch ((Reg & 0xF0) >> 4)
	{
	case 0:
		x = x & 0x07;
		Instrument[0][x] = Value;
		for (y = 0; y < 6; y++)
		{
			if (SoundInfo[0][y] == 0)
			{
				switch (x)
				{
				case 0x00:
					OPL2_setreg(0x20 + InstTrans[y],Value);
					break;
				case 0x01:
					OPL2_setreg(0x23 + InstTrans[y],Value);
					break;
				case 0x02:
					OPL2_setreg(0x40 + InstTrans[y],Value);
					break;
				case 0x03:
					OPL2_setreg(0xe0 + InstTrans[y],(Value & 0x08) >> 3);
					OPL2_setreg(0xe3 + InstTrans[y],(Value & 0x10) >> 5);
					SoundInfo[2][y] = (Value & 0xC0) | (SoundInfo[2][y] & 0x3F);
					OPL2_setreg(0x43 + InstTrans[y],SoundInfo[2][y]);
					OPL2_setreg(0xC0 + InstTrans[y],(Value & 0x07) << 1);
					break;
				case 0x04:
					OPL2_setreg(0x60 + InstTrans[y],Value);
					break;
				case 0x05:
					OPL2_setreg(0x63 + InstTrans[y],Value);
					break;
				case 0x06:
					OPL2_setreg(0x80 + InstTrans[y],Value);
					break;
				case 0x07:
					OPL2_setreg(0x83 + InstTrans[y],Value);
					break;
				}
			}
		}
		break;
	case 1:
		OPL2_setreg(0xA0 + x,Value << 1);
		SoundInfo[1][x] = (Value >> 7) | (SoundInfo[1][x] & 0xFE);
		OPL2_setreg(0xB0 + x,SoundInfo[1][x]);
		break;
	case 2:
/*		if (Value & 0x20)
		{
			OPL2_setreg(0x23 + InstTrans[x],Instrument[SoundInfo[0][x]][1] | 0x20);
		}
		else
		{
			OPL2_setreg(0x23 + InstTrans[x],Instrument[SoundInfo[0][x]][1] & 0xDF);
			OPL2_setreg(0x80 + InstTrans[x],Instrument[SoundInfo[0][x]][6] & 0x0F);
			OPL2_setreg(0x83 + InstTrans[x],Instrument[SoundInfo[0][x]][7] & 0x0F);
		} */
		SoundInfo[1][x] = ((Value << 1) & 0x3F) | (SoundInfo[1][x] & 0x01);
		OPL2_setreg(0xB0 + x,SoundInfo[1][x]);
		break;
	case 3:
		y = Value >> 4;
		SoundInfo[0][x] = y;
		OPL2_setreg(0x20 + InstTrans[x],Instrument[y][0]);
		OPL2_setreg(0x23 + InstTrans[x],Instrument[y][1]);
		OPL2_setreg(0x40 + InstTrans[x],Instrument[y][2]);
		OPL2_setreg(0xe0 + InstTrans[x],(Instrument[y][3] & 0x08) >> 3);
		OPL2_setreg(0xe3 + InstTrans[x],(Instrument[y][3] & 0x10) >> 4);
		SoundInfo[2][x] = (Instrument[y][3] & 0xC0) | ((Value & 0x0F) << 1);
		OPL2_setreg(0x43 + InstTrans[x],SoundInfo[2][x]);
		OPL2_setreg(0xC0 + InstTrans[x],(Instrument[y][3] & 0x07) << 1);
 		OPL2_setreg(0x60 + InstTrans[x],Instrument[y][4]);
		OPL2_setreg(0x63 + InstTrans[x],Instrument[y][5]);
		OPL2_setreg(0x80 + InstTrans[x],Instrument[y][6]);
		OPL2_setreg(0x83 + InstTrans[x],Instrument[y][7]);
		break;
	}
} 
