library Map001;

uses
  Windows,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 1;
  VersionLo : 1;
  VersionHi : 1;
  BankSize  : 16384;
  Name      : 'MMC1';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions
 Latch:Byte;
 LatchCtr:Byte;
 Regs:Array[0..3] of Byte;
 PrgHi,PrgLo:Byte;

Procedure MapperWrite(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (What AND $80) <> 0 then  // Reset latch
  begin
   Latch := 0;
   LatchCtr := 5;
   Regs[0] := Regs[0] OR $0C;
   Page := 0;
  end
 else
  begin // Normal write
   What := What AND 1;
   Latch := Latch OR (What shl LatchCtr);
   Inc(LatchCtr);
  end;

 If (LatchCtr = 5) then
  begin
   If (Page > 0) then
    Regs[(Page-$8) shr 1] := Latch AND $1f;

  // Reset Latches
   Latch := 0;
   LatchCtr := 0;

  // Set mirroring
  Case (Regs[0] AND $3) of
   0:MP.Mirror_S0;
   1:MP.Mirror_S1;
   2:MP.Mirror_V;
   3:MP.Mirror_H;
  end;

  // Set CHRROM
   If (Regs[0] AND $10) = 0 then  // 8k @ 0000 swap
    Regs[2] := Regs[1]+1;

   MP.SetCHR_0000_0FFF(Regs[1]);
   MP.SetCHR_1000_1FFF(Regs[2]);

  // Set PRGROM
   If (Regs[0] AND $08) = 0 then   // 32k @ 8000
    begin
     PrgLo := Regs[3];
     PrgHi := Regs[3]+1;
    end
   else // 16k
    If (Regs[0] AND $04) <> 0 then // 16k @ 8000
     PrgLo := Regs[3] else PrgHi := Regs[3];

   MP.SetPRG_89AB(PrgLo OR (Regs[1] AND $10));
   MP.SetPRG_CDEF(PrgHi OR (Regs[1] AND $10));
  end;
end;

Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
//Mapper 1
//--------
//  0-3   The last values written to each of the 4 registers
//  4     Latch register
//  5     Number of bits (0-4) that have been written to the current
//        unfinished register
 MI[0] := Regs[0];
 MI[1] := Regs[1];
 MI[2] := Regs[2];
 MI[3] := Regs[3];
 MI[4] := Latch;
 MI[5] := LatchCtr;
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
 PrgLo    := MP.GetPRG_Custom($8,16384) AND $0F;
 PrgHi    := MP.GetPRG_Custom($C,16384) AND $0F;
 Regs[0]  := MI[0];
 Regs[1]  := MI[1];
 Regs[2]  := MI[2];
 Regs[3]  := MI[3];
 Latch    := MI[4];
 LatchCtr := MI[5];
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper 1',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
var
 X:LongInt;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 For X := $8 to $F do
  MP.SetWriteHandler(X,MapperWrite);

 PrgLo := $00;
 PrgHi := $0F;
 MP.SetPRG_89AB(PrgLo);
 MP.SetPRG_CDEF(PrgHi);

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

 Regs[0] := 0;
 Regs[1] := 0;
 Regs[2] := 0;
 Regs[3] := 0;

 MapperWrite(8,0,$80); // Reset mapper

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI;

begin
end.
