library Map004;

uses
  Windows,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 4;
  VersionLo : 2;
  VersionHi : 1;
  BankSize  : 8192;    // This is the minimum switchable bank size
  Name      : 'MMC3';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions
 IRQ_Counter, IRQ_Latch, IRQ_Enabled:Byte;
 Command:Byte;
 Bank0,Bank2:Byte; // Bank0 = 89, Bank2 = CD, AB and EF = always the same (only 0 and 2 can be switched)
 cBank0,cBank1,cBank2,cBank3,cBank4,cBank5,cBank6,cBank7:Byte;
 FourScreen:Boolean;

Procedure CMD1Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
var
 vxor,pswp:Boolean;
begin
 Case Where of
  $000:begin
        Command := What;
        If (Command AND $40) = 0 then
         begin
          MP.SetPRG_89(Bank0);
          MP.SetPRG_CD(Bank2);
         end
        else
         begin
          MP.SetPRG_CD(Bank0);
          MP.SetPRG_89(Bank2);
         end;
        If (Command AND $80) = 0 then
         begin
          MP.SetCHR_0000_03FF(cBank0);
          MP.SetCHR_0400_07FF(cBank1);
          MP.SetCHR_0800_0BFF(cBank2);
          MP.SetCHR_0C00_0FFF(cBank3);
          MP.SetCHR_1000_13FF(cBank4);
          MP.SetCHR_1400_17FF(cBank5);
          MP.SetCHR_1800_1BFF(cBank6);
          MP.SetCHR_1C00_1FFF(cBank7);
         end
        else
         begin
          MP.SetCHR_0000_03FF(cBank4);
          MP.SetCHR_0400_07FF(cBank5);
          MP.SetCHR_0800_0BFF(cBank6);
          MP.SetCHR_0C00_0FFF(cBank7);
          MP.SetCHR_1000_13FF(cBank0);
          MP.SetCHR_1400_17FF(cBank1);
          MP.SetCHR_1800_1BFF(cBank2);
          MP.SetCHR_1C00_1FFF(cBank3);
         end;
       end;
  $001:begin
        vxor := (Command AND $80) = 0;
        pswp := (Command AND $40) = 0;
        Case Command AND $7 of
         0:begin
            cBank0 := What;
            cBank1 := What + 1;
            if (vxor) then
             begin
              MP.SetCHR_0000_03FF(cBank0);
              MP.SetCHR_0400_07FF(cBank1);
             end
            else
             begin
              MP.SetCHR_1000_13FF(cBank0);
              MP.SetCHR_1400_17FF(cBank1);
             end;
           end;
         1:begin
            cBank2 := What;
            cBank3 := What + 1;
            if (vxor) then
             begin
              MP.SetCHR_0800_0BFF(cBank2);
              MP.SetCHR_0C00_0FFF(cBank3);
             end
            else
             begin
              MP.SetCHR_1800_1BFF(cBank2);
              MP.SetCHR_1C00_1FFF(cBank3);
             end;
           end;
         2:begin
            cBank4 := What;
            if (vxor) then
             MP.SetCHR_1000_13FF(cBank4)
            else
             MP.SetCHR_0000_03FF(cBank4);
           end;
         3:begin
            cBank5 := What;
            if (vxor) then
             MP.SetCHR_1400_17FF(cBank5)
            else
             MP.SetCHR_0400_07FF(cBank5);
           end;
         4:begin
            cBank6 := What;
            if (vxor) then
             MP.SetCHR_1800_1BFF(cBank6)
            else
             MP.SetCHR_0800_0BFF(cBank6);
           end;
         5:begin
            cBank7 := What;
            if (vxor) then
             MP.SetCHR_1C00_1FFF(cBank7)
            else
             MP.SetCHR_0C00_0FFF(cBank7);
           end;
         6:if (pswp) then
            begin
             Bank0 := What;
             MP.SetPRG_89(Bank0);
             MP.SetPRG_CD(Bank2);
            end
           else
            begin
             Bank0 := What;
             MP.SetPRG_CD(Bank0);
             MP.SetPRG_89(Bank2);
            end;
         7:MP.SetPRG_AB(What);
        end;
       end;
 end;
end;

Procedure CMD2Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where of
  0:If Not(FourScreen) then
     If (What AND $01) <> 0 then
      MP.Mirror_H else MP.Mirror_V;
 end;
end;

Procedure CMD3Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where of
  0:IRQ_Counter := What;//+1;
  1:IRQ_Latch := What;//+1;
 end;
end;

Procedure CMD4Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where of
  0:begin
     IRQ_Enabled := 0;
     IRQ_Counter := IRQ_Latch;
    end;
  1:begin
     IRQ_Enabled := 1;
    end;
 end;
end;

Function HBlank(ScanLine:LongInt; Byte2001:LongInt):LongInt; cDecl;
begin
 Result := 0; // No IRQ
 If (ScanLine = 0) then
  begin
   IRQ_Counter := IRQ_Latch;  // IRQ_Latch-1 ???
   Exit;
  end;
 If (ScanLine > 239) then exit; // Do nothing
 If (IRQ_Enabled <> 0) AND ((Byte2001 AND $18) <> 0) then
  begin
   Dec(IRQ_Counter);
   If (IRQ_Counter = $00) then
    begin
     Result := 1;
     IRQ_Counter := IRQ_Latch;
    end;
  end;
// If (Scanline = 240) then IRQ_Counter := IRQ_Latch;
end;

Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
//Mapper 4
//--------
//  0     IRQ Counter
//  1     IRQ Latch Counter
//  2     (boolean) IRQ Counter Enabled
//  3     Last value written to $8000
 MI[0] := IRQ_Counter;
 MI[1] := IRQ_Latch;
 MI[2] := IRQ_Enabled;
 MI[3] := Command;
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
 IRQ_Counter := MI[0];
 IRQ_Latch   := MI[1];
 IRQ_Enabled := MI[2];
 Command     := MI[3];
 If (Command AND $40) = 0 then
  begin
   Bank0 := MP.GetPRG_Custom($8,8192);
   Bank2 := MP.GetPRG_Custom($C,8192);
  end
 else
  begin
   Bank2 := MP.GetPRG_Custom($8,8192);
   Bank0 := MP.GetPRG_Custom($C,8192);
  end;
 If (Command AND $80) = 0 then
  begin
   cBank0 := MP.GetCHR_Custom($0,1024);
   cBank1 := MP.GetCHR_Custom($1,1024);
   cBank2 := MP.GetCHR_Custom($2,1024);
   cBank3 := MP.GetCHR_Custom($3,1024);
   cBank4 := MP.GetCHR_Custom($4,1024);
   cBank5 := MP.GetCHR_Custom($5,1024);
   cBank6 := MP.GetCHR_Custom($6,1024);
   cBank7 := MP.GetCHR_Custom($7,1024);
  end
 else
  begin
   cBank0 := MP.GetCHR_Custom($4,1024);
   cBank1 := MP.GetCHR_Custom($5,1024);
   cBank2 := MP.GetCHR_Custom($6,1024);
   cBank3 := MP.GetCHR_Custom($7,1024);
   cBank4 := MP.GetCHR_Custom($0,1024);
   cBank5 := MP.GetCHR_Custom($1,1024);
   cBank6 := MP.GetCHR_Custom($2,1024);
   cBank7 := MP.GetCHR_Custom($3,1024);
  end;


end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper4',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 MP.SetWriteHandler($8,CMD1Write);
 MP.SetWriteHandler($A,CMD2Write);
 MP.SetWriteHandler($C,CMD3Write);
 MP.SetWriteHandler($E,CMD4Write);

 MP.SetPRG_89AB(0);  // Set first bank
 MP.SetPRG_CDEF(-1); // Set last bank

 Bank0 := MP.GetPRG_Custom($8,8192);
 Bank2 := MP.GetPRG_Custom($C,8192);

 cBank0 := MP.GetCHR_Custom($0,1024);
 cBank1 := MP.GetCHR_Custom($1,1024);
 cBank2 := MP.GetCHR_Custom($2,1024);
 cBank3 := MP.GetCHR_Custom($3,1024);
 cBank4 := MP.GetCHR_Custom($4,1024);
 cBank5 := MP.GetCHR_Custom($5,1024);
 cBank6 := MP.GetCHR_Custom($6,1024);
 cBank7 := MP.GetCHR_Custom($7,1024);

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 FourScreen := (MP.Flag1 AND 8) <> 0;
 If (FourScreen) then
  MP.Mirror_4
 else
  if ((MP.Flag1 AND 1) <> 0) then
   MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI,HBlank;

begin
end.
