library Map006;

uses
  Windows,
  SysUtils,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 6;
  VersionLo : 0;
  VersionHi : 1;
  BankSize  : 16384;
  Name      : 'FFE F4xxx';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions
 IRQCounter:LongInt;
 IRQEnabled:Byte;
 Wr4K:TWriteFunc;

Procedure MapperWrite1(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where of
  0..$17:Wr4K(Page,Where,What);
  $2FE:If (What AND $10) <> 0 then
        MP.Mirror_S1 else MP.Mirror_S0;
  $2FF:If (What AND $10) <> 0 then
        MP.Mirror_H else MP.Mirror_V;
  $501:IRQEnabled := 0;
  $502:IRQCounter := What; // OR (IRQCounter  AND $FF00);
  $503:begin
        IRQCounter := (What shl 8) OR (IRQCounter); //AND $FF);
        IRQEnabled := 1;
       end;
  else MP.DbgOut(PChar('Unknown write '+IntToHex(What,2)+' to '+IntToHex(Page,1)+IntToHex(Where,3)));
 end;

end;

Procedure MapperWrite2(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 MP.SetPRG_89AB((What shr 2) AND $0f);
 MP.SetCHR_RAM(What AND 3);
end;

Function HBlank(ScanLine:LongInt; Byte2001:LongInt):LongInt; cDecl;
begin
 Result := 0;
 If (IRQEnabled <> 0) AND (IRQCounter <> 0) then
  begin
   Inc(IRQCounter,114); // 114 cycles pr scanline
   If (IRQCounter > $FFFF) then
    begin
     Result := 1;
     IRQCounter := 0;
    end;
  end;
end;


Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
 MI[0] := Lo(IRQCounter);
 MI[1] := Hi(IRQCounter);
 MI[2] := IRQEnabled;
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
 IRQCounter := MI[0];
 IRQCounter := (MI[1] shl 8) OR IRQCounter;
 IRQEnabled := MI[2];
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper 6',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
var
 X:LongInt;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 Wr4K := MP.GetWriteHandler($4);
 MP.SetWriteHandler($4,MapperWrite1);

 For X := $8 to $f do
  MP.SetWriteHandler(X,MapperWrite2);

 MP.SetPRG_89AB(0);
 MP.SetPRG_CDEF(7);

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI,HBlank;

begin
end.
