library Map007;

uses
  Windows,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 7;
  VersionLo : 0;
  VersionHi : 1;
  BankSize  : 32768;
  Name      : 'AOROM';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions

Procedure PRG_Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 MP.SetPRG_89ABCDEF(What AND $F);
 If (What AND $10) <> $0 then
  MP.Mirror_S1 else MP.Mirror_S0;
end;

Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
 // Mapper 0, does nothing extra ktnx.
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper7',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
var
 X:LongInt;
begin
 // Copy the passed parameters
 MP := MapperParam;

 For X := $8 to $F do
  MP.SetWriteHandler(X,PRG_Write);

 MP.SetPRG_89ABCDEF(0);

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI;

begin
end.
