library Map009;

uses
  Windows,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 9;
  VersionLo : 0;
  VersionHi : 1;
  BankSize  : 8192;
  Name      : 'MMC2';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions
 Latch0,Latch1:Byte;
 Latch0FD,Latch0FE:Byte;
 Latch1FD,Latch1FE:Byte;

Procedure PRGSel(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 MP.SetPRG_89(What);
end;

Procedure MirrorSel(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (What = 0) then
  MP.Mirror_V else MP.Mirror_H;
end;

Procedure Latch0FDSel(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Latch0FD := What;
 If (Latch0 = $FD) then MP.SetCHR_0000_0FFF(What);
end;

Procedure Latch0FESel(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Latch0FE := What;
 If (Latch0 = $FE) then MP.SetCHR_0000_0FFF(What);
end;

Procedure Latch1FDSel(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Latch1FD := What;
 If (Latch1 = $FD) then MP.SetCHR_1000_1FFF(What);
end;

Procedure Latch1FESel(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Latch1FE := What;
 If (Latch1 = $FE) then MP.SetCHR_1000_1FFF(What);
end;


Function TileHandler(Hi:LongInt; TileNum:LongInt):LongInt; cDecl;
begin
 If (TileNum = 253) then
  begin
   If (Hi = 0) then // $0FD0
    begin
     MP.SetCHR_0000_0FFF(Latch0FD);
     Latch0 := $FD;
    end
   else             // $1FD0
    begin
     MP.SetCHR_1000_1FFF(Latch1FD);
     Latch1 := $FD;
    end;
   Result := 1;
  end
 else if (TileNum = 254) then
  begin
   If (Hi = 0) then // $0FE0
    begin
     MP.SetCHR_0000_0FFF(Latch0FE);
     Latch0 := $FE;
    end
   else             // $1FE0
    begin
     MP.SetCHR_1000_1FFF(Latch1FE);
     Latch1 := $FE;
    end;
   Result := 1;
  end else Result := 0;
end;

Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
 MI[0] := Latch0;
 MI[1] := Latch1;
 MI[2] := Latch0FD;
 MI[3] := Latch0FE;
 MI[4] := Latch1FD;
 MI[5] := Latch1FE;
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
 Latch0   := MI[0];
 Latch1   := MI[1];
 Latch0FD := MI[2];
 Latch0FE := MI[3];
 Latch1FD := MI[4];
 Latch1FE := MI[5];
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper9',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 Latch0 := $FE; // Starting latch values
 Latch1 := $FE;

 MP.SetWriteHandler($A,PRGSel);
 MP.SetWriteHandler($B,Latch0FDSel);
 MP.SetWriteHandler($C,Latch0FESel);
 MP.SetWriteHandler($D,Latch1FDSel);
 MP.SetWriteHandler($E,Latch1FESel);
 MP.SetWriteHandler($F,MirrorSel);

 MP.SetPRG_89ABCDEF(-1); // Set 3 last banks to last
 MP.SetPRG_89(0);        // Set first bank to first

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI,TileHandler;

begin
end.
