library Map016;

uses
  Windows,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 16;
  VersionLo : 0;
  VersionHi : 1;
  BankSize  : 16384;
  Name      : 'Bandai';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions
 IRQCounter:Integer;
 IRQEnabled:Byte;

Procedure MapperWrite(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where of
  $000,$FF0:MP.SetCHR_0000_03FF(What);
  $001,$FF1:MP.SetCHR_0400_07FF(What);
  $002,$FF2:MP.SetCHR_0800_0BFF(What);
  $003,$FF3:MP.SetCHR_0C00_0FFF(What);
  $004,$FF4:MP.SetCHR_1000_13FF(What);
  $005,$FF5:MP.SetCHR_1400_17FF(What);
  $006,$FF6:MP.SetCHR_1800_1BFF(What);
  $007,$FF7:MP.SetCHR_1C00_1FFF(What);
  $008,$FF8:MP.SetPRG_89AB(What);
  $009,$FF9:If (What AND 2) <> 0 then
             begin
              If (What AND 1) <> 0 then
               MP.Mirror_S1 else MP.Mirror_S0;
             end
            else
             begin
              If (What AND 1) <> 0 then
               MP.Mirror_H else MP.Mirror_V;
             end;
  $00A,$FFA:IRQEnabled := What AND 1;
  $00B,$FFB:IRQCounter := What;
  $00C,$FFC:IRQCounter := (What shl 8) OR IRQCounter;
  $00D,$FFD:;
  else MP.DbgOut('Unknown write!');
 end;
end;

Function  HBlank(ScanLine:LongInt; Byte2001:LongInt):LongInt; cDecl;
begin
 Result := 0;
 If (IRQEnabled <> 0) then
  begin
   Dec(IRQCounter,114);
   If (IRQCounter < 0) then Result := 1;
  end;
end;

Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
 MI[0] := Lo(IRQCounter);
 MI[1] := Hi(IRQCounter);
 MI[2] := IRQEnabled;
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
 IRQCounter := MI[0];
 IRQCounter := (MI[1] shl 8) OR IRQCounter;
 IRQEnabled := MI[2];
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper16',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
var
 X:LongInt;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 For X := $8 to $F do
  MP.SetWriteHandler(X,MapperWrite);

 MP.SetPRG_89AB(0);
 MP.SetPRG_CDEF(-1);

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI,HBlank;

begin
end.
