library Map017;

uses
  Windows,
//  SysUtils,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 17;
  VersionLo : 0;
  VersionHi : 1;
  BankSize  : 8192;
  Name      : 'FFE F8xxx';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions
 IRQCounter:LongInt;
 IRQEnabled:Byte;
 Wr4K:TWriteFunc;

Procedure MapperWrite(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where of
  0..$17:Wr4K(Page,Where,What);     // Call old handler
  $2FE:If (What AND $10) <> 0 then
        MP.Mirror_S1 else MP.Mirror_S0;
  $2FF:If (What AND $10) <> 0 then
        MP.Mirror_H else MP.Mirror_V;
  $500:; //IRQCounter := What;
  $501:IRQEnabled := 0;
  $502:IRQCounter := What; // (IRQCounter AND $FF00);
  $503:begin
        IRQCounter := (What shl 8) OR (IRQCounter); //AND $FF);
        IRQEnabled := 1;
       end;
  $504:MP.SetPRG_89(What);
  $505:MP.SetPRG_AB(What);
  $506:MP.SetPRG_CD(What);
  $507:MP.SetPRG_EF(What);
  $510:MP.SetCHR_0000_03FF(What);
  $511:MP.SetCHR_0400_07FF(What);
  $512:MP.SetCHR_0800_0BFF(What);
  $513:MP.SetCHR_0C00_0FFF(What);
  $514:MP.SetCHR_1000_13FF(What);
  $515:MP.SetCHR_1400_17FF(What);
  $516:MP.SetCHR_1800_1BFF(What);
  $517:MP.SetCHR_1C00_1FFF(What);
//  else MP.DbgOut(PChar('Unknown write '+IntToHex(What,2)+' to '+IntToHex(Page,1)+IntToHex(Where,3)));
 end;

end;

Function  HBlank(ScanLine:LongInt; Byte2001:LongInt):LongInt; cDecl;
begin
 Result := 0;
 If (IRQEnabled <> 0) AND (IRQCounter <> 0) then
  begin
   Inc(IRQCounter,114);
   If (IRQCounter > $FFFF) then
    begin
     Result := 1;
     IRQCounter := 0;
    end;
  end;

end;

Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
 MI[0] := Lo(IRQCounter);
 MI[1] := Hi(IRQCounter);
 MI[2] := IRQEnabled;
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
 IRQCounter := MI[0];
 IRQCounter := (MI[1] shl 8) OR IRQCounter;
 IRQEnabled := MI[2];
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper17',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 Wr4K := MP.GetWriteHandler($4); // Get old handler
 MP.SetWriteHandler($4,MapperWrite); // Set new handler

 MP.SetPRG_89AB(0);
 MP.SetPRG_CDEF(-1);

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI,HBlank;

begin
end.
