library Map019;

uses
  Windows,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 19;
  VersionLo : 0;
  VersionHi : 1;
  BankSize  : 8192;
  Name      : 'Namcot 106';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions
 IRQW:Word;
 IRQEnabled:Byte;

Procedure IRQWrite(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (Where < $800) then
  IRQW := (IRQW AND $7F00) OR What
 else
  begin
   IRQEnabled := Byte((What AND $80) <> 0);
   IRQW := (IRQW AND $FF) OR ((What AND $7F) shl 8);
  end;
end;

Procedure CHR1Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (Where < $800) then
  MP.SetCHR_0000_03FF(What) else MP.SetCHR_0400_07FF(What);
end;

Procedure CHR2Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (Where < $800) then
  MP.SetCHR_0800_0BFF(What) else MP.SetCHR_0C00_0FFF(What);
end;

Procedure CHR3Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (Where < $800) then
  MP.SetCHR_1000_13FF(What) else MP.SetCHR_1400_17FF(What);
end;

Procedure CHR4Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (Where < $800) then
  MP.SetCHR_1800_1BFF(What) else MP.SetCHR_1C00_1FFF(What);
end;

Procedure VRAM1Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (Where < $800) then ; // ouch

end;

Procedure VRAM2Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (Where < $800) then ; // ouch

end;

Procedure PRG1Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (Where < $800) then
  MP.SetPRG_89(What) else MP.SetPRG_AB(What);
end;

Procedure PRG2Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (Where < $800) then
  MP.SetPRG_CD(What);
end;

Function  HBlank(ScanLine:LongInt; Byte2001:LongInt):LongInt; cDecl;
begin
 Result := 0;
 Inc(IRQW);
 If (IRQEnabled <> 0) AND (IRQW = $7FFF) then Result := 1;
end;


Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
 MI[0] := Lo(IRQW);
 MI[1] := Hi(IRQW);
 MI[2] := IRQEnabled;
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
 IRQW := MI[0] OR MI[1] shl 8;
 IRQEnabled := MI[2];
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper19',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 MP.SetWriteHandler($5,IRQWrite);
 MP.SetWriteHandler($8,CHR1Write);
 MP.SetWriteHandler($9,CHR2Write);
 MP.SetWriteHandler($A,CHR3Write);
 MP.SetWriteHandler($B,CHR4Write);
 MP.SetWriteHandler($C,VRAM1Write);
 MP.SetWriteHandler($D,VRAM2Write);
 MP.SetWriteHandler($E,PRG1Write);
 MP.SetWriteHandler($F,PRG2Write);

 MP.SetPRG_89AB(0);
 MP.SetPRG_CDEF(-1);

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI;

begin
end.
