library Map022;

uses
  Windows,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 22;
  VersionLo : 0;
  VersionHi : 1;
  BankSize  : 8192;
  Name      : 'Konami VRC2 Type A';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions

Procedure PRG1Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
// If (Where = $0) then
  MP.SetPRG_89(What);
end;

Procedure PRG2Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
// If (Where = $0) then
  MP.SetPRG_AB(What);
end;

Procedure MirrorWrite(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (Where = $0) then
  begin
   If (What AND 2) <> 0 then
    begin
     If (What AND 1) <> 0 then
      MP.Mirror_S0 else MP.Mirror_S1;
    end
   else
    begin
     If (What AND 1) <> 0 then
      MP.Mirror_H else MP.Mirror_V;
    end;
  end;
end;


Procedure CHR1Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 What := What shr 1;
 If (Where = $0) then
  MP.SetCHR_0000_03FF(What)
 else if (Where = $1) then
  MP.SetCHR_0400_07FF(What);
end;

Procedure CHR2Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 What := What shr 1;
 If (Where = $0) then
  MP.SetCHR_0800_0BFF(What)
 else if (Where = $1) then
  MP.SetCHR_0C00_0FFF(What);
end;

Procedure CHR3Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 What := What shr 1;
 If (Where = $0) then
  MP.SetCHR_1000_13FF(What)
 else if (Where = $1) then
  MP.SetCHR_1400_17FF(What);
end;

Procedure CHR4Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 What := What shr 1;
 If (Where = $0) then
  MP.SetCHR_1800_1BFF(What)
 else if (Where = $1) then
  MP.SetCHR_1C00_1FFF(What);
end;


Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
 // Mapper 0, does nothing extra ktnx.
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper22',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 MP.SetWriteHandler($8,PRG1Write);
 MP.SetWriteHandler($9,MirrorWrite);
 MP.SetWriteHandler($A,PRG2Write);
 MP.SetWriteHandler($B,CHR1Write);
 MP.SetWriteHandler($C,CHR2Write);
 MP.SetWriteHandler($D,CHR3Write);
 MP.SetWriteHandler($E,CHR4Write);

 MP.SetPRG_89AB(0);
 MP.SetPRG_CDEF(-1);

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI;

begin
end.
