library Map023;

uses
  Windows,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 23;
  VersionLo : 0;
  VersionHi : 1;
  BankSize  : 8192;
  Name      : 'Konami VRC2 Type B';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions
 CHR0,CHR1,CHR2,CHR3,CHR4,CHR5,CHR6,CHR7:Byte;

Procedure PRG1Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
// If (Where = $0) OR (Where = $FFF) then
  MP.SetPRG_89(What);
end;

Procedure PRG2Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
// If (Where = $0) OR (Where = $FFF) then
  MP.SetPRG_AB(What);
end;

Procedure MirrorWrite(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
// If (Where = $0) then
//  begin
   If (What AND 2) <> 0 then
    begin
     If (What AND 1) <> 0 then
      MP.Mirror_S0 else MP.Mirror_S1;
    end
   else
    begin
     If (What AND 1) <> 0 then
      MP.Mirror_H else MP.Mirror_V;
    end;
//  end;
end;


Procedure CHR1Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 What := What AND $0F;
 Case (Where AND $3) of
  $000:begin
        CHR0 := (CHR0 AND $F0) OR What;
        MP.SetCHR_0000_03FF(CHR0);
       end;
  $001:begin
        CHR0 := (CHR0 AND $0F) OR (What shl 4);
        MP.SetCHR_0000_03FF(CHR0);
       end;
  $002:begin
        CHR1 := (CHR1 AND $F0) OR What;
        MP.SetCHR_0400_07FF(CHR1);
       end;
  $003:begin
        CHR1 := (CHR1 AND $0F) OR (What shl 4);
        MP.SetCHR_0400_07FF(CHR1);
       end;
 end;
end;

Procedure CHR2Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 What := What AND $0F;
 Case (Where AND $3) of
  $000:begin
        CHR2 := (CHR2 AND $F0) OR What;
        MP.SetCHR_0800_0BFF(CHR2);
       end;
  $001:begin
        CHR2 := (CHR2 AND $0F) OR (What shl 4);
        MP.SetCHR_0800_0BFF(CHR2);
       end;
  $002:begin
        CHR3 := (CHR3 AND $F0) OR What;
        MP.SetCHR_0C00_0FFF(CHR3);
       end;
  $003:begin
        CHR3 := (CHR3 AND $0F) OR (What shl 4);
        MP.SetCHR_0C00_0FFF(CHR3);
       end;
 end;
end;


Procedure CHR3Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 What := What AND $0F;
 Case (Where AND $3) of
  $000:begin
        CHR4 := (CHR4 AND $F0) OR What;
        MP.SetCHR_1000_13FF(CHR4);
       end;
  $001:begin
        CHR4 := (CHR4 AND $0F) OR (What shl 4);
        MP.SetCHR_1000_13FF(CHR4);
       end;
  $002:begin
        CHR5 := (CHR5 AND $F0) OR What;
        MP.SetCHR_1400_17FF(CHR5);
       end;
  $003:begin
        CHR5 := (CHR5 AND $0F) OR (What shl 4);
        MP.SetCHR_1400_17FF(CHR5);
       end;
 end;
end;

Procedure CHR4Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 What := What AND $0F;
 Case (Where AND $3) of
  $000:begin
        CHR6 := (CHR6 AND $F0) OR What;
        MP.SetCHR_1800_1BFF(CHR6);
       end;
  $001:begin
        CHR6 := (CHR6 AND $0F) OR (What shl 4);
        MP.SetCHR_1800_1BFF(CHR6);
       end;
  $002:begin
        CHR7 := (CHR7 AND $F0) OR What;
        MP.SetCHR_1C00_1FFF(CHR7);
       end;
  $003:begin
        CHR7 := (CHR7 AND $0F) OR (What shl 4);
        MP.SetCHR_1C00_1FFF(CHR7);
       end;
 end;
end;

Procedure IRQWrite(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 MP.DbgOut('IRQWrite?');
end;

Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
 MI[0] := CHR0;
 MI[1] := CHR1;
 MI[2] := CHR2;
 MI[3] := CHR3;
 MI[4] := CHR4;
 MI[5] := CHR5;
 MI[6] := CHR6;
 MI[7] := CHR7;
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
 CHR0 := MI[0];
 CHR1 := MI[1];
 CHR2 := MI[2];
 CHR3 := MI[3];
 CHR4 := MI[4];
 CHR5 := MI[5];
 CHR6 := MI[6];
 CHR7 := MI[7];
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper23',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 MP.SetWriteHandler($8,PRG1Write);
 MP.SetWriteHandler($9,MirrorWrite);
 MP.SetWriteHandler($A,PRG2Write);
 MP.SetWriteHandler($B,CHR1Write);
 MP.SetWriteHandler($C,CHR2Write);
 MP.SetWriteHandler($D,CHR3Write);
 MP.SetWriteHandler($E,CHR4Write);
 MP.SetWriteHandler($F,IRQWrite);

 MP.SetPRG_89AB(0);
 MP.SetPRG_CDEF(-1);

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI;

begin
end.
