library Map026;

uses
  Windows,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 26;
  VersionLo : 0;
  VersionHi : 1;
  BankSize  : 8192;
  Name      : 'Konami VRC6 A1/A0';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions
 IRQCounter:Byte;
 IRQLatch:Byte;
 IRQEnabled:Byte;

Procedure PRG1Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (Where = $0) then
  MP.SetPRG_89AB(What);
end;

Procedure PRG2Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (Where = $0) then
  MP.SetPRG_CD(What);
end;

Procedure CHR1Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where of
  $000:MP.SetCHR_0000_03FF(What);
  $002:MP.SetCHR_0400_07FF(What);
  $001:MP.SetCHR_0800_0BFF(What);
  $003:MP.SetCHR_0C00_0FFF(What);
 end;
end;

Procedure CHR2Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where of
  $000:MP.SetCHR_1000_13FF(What);
  $002:MP.SetCHR_1400_17FF(What);
  $001:MP.SetCHR_1800_1BFF(What);
  $003:MP.SetCHR_1C00_1FFF(What);
 end;
end;

Procedure IRQWrite(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where AND $3 of
  0:begin
     IRQLatch := What-1;
    end;
  2:begin
     IRQEnabled := What AND 3;
     IRQCounter := IRQLatch;
    end;
  1:begin
     IRQEnabled := (IRQEnabled shl 1) OR (IRQEnabled AND 1);
     IRQCounter := IRQLatch;
    end;
  else MP.DbgOut('Unk write!');
 end;
end;


Function  HBlank(ScanLine:LongInt; Byte2001:LongInt):LongInt; cDecl;
begin
 Result := 0;
 If ((IRQEnabled AND 2) <> 0){ AND (IRQCounter <> 0)}then
  begin
   Inc(IRQCounter);
   If (IRQCounter = 0) then
    begin
     Result := 1;
     IRQCounter := IRQLatch;
//     IRQEnabled := IRQEnabled shl 1;
//     If (IRQEnabled <> 0) then IRQCounter := IRQLatch;
    end;

  end;
end;

Procedure MirrorWrite(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where of
  $000:MP.VRC6Write(2,0,What);
  $001:MP.VRC6Write(2,2,What);
  $002:MP.VRC6Write(2,1,What);
  $003:begin
        If (What AND 8) <> 0 then
         begin
          If (What AND 4) <> 0 then
           MP.Mirror_S1 else MP.Mirror_S0;
         end
        else
         begin
          If (What AND 4) <> 0 then
           MP.Mirror_H else MP.Mirror_V;
         end;
       end;
 end;
end;



Procedure SndWrite(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Dec(Page,$9);
 Case Where of
  0:MP.VRC6Write(Page,0,What);
  1:MP.VRC6Write(Page,2,What);
  2:MP.VRC6Write(Page,1,What);
 end;
end;

Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
 MI[0] := IRQCounter;
 MI[1] := IRQLatch;
 MI[2] := IRQEnabled;
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
 IRQCounter := MI[0];
 IRQLatch   := MI[1];
 IRQEnabled := MI[2];
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper26',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 MP.SetWriteHandler($8,PRG1Write);
 MP.SetWriteHandler($9,SndWrite);
 MP.SetWriteHandler($A,SndWrite);
 MP.SetWriteHandler($B,MirrorWrite);
 MP.SetWriteHandler($C,PRG2Write);
 MP.SetWriteHandler($D,CHR1Write);
 MP.SetWriteHandler($E,CHR2Write);
 MP.SetWriteHandler($F,IRQWrite);

 MP.SetPRG_89AB(0);
 MP.SetPRG_CDEF(-1);

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI,HBlank;

begin
end.
