library Map032;

uses
  Windows,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 32;
  VersionLo : 0;
  VersionHi : 1;
  BankSize  : 8192;
  Name      : 'Irem G-101';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions
 b9xxx:Byte;

Procedure PRG1Select(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
// If (Where = $FFF) then
  If (b9xxx AND $2) <> 0 then
   MP.SetPRG_CD(What) else MP.SetPRG_89(What);
end;

Procedure PRG2Select(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
// If (Where = $FFF) then
  MP.SetPRG_AB(What);
end;

Procedure BankMirror(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
// If (Where = $FFF) then
//  begin
   b9xxx := What;
   If (What AND $1) <> 0 then
    MP.Mirror_H else MP.Mirror_V;
//  end;
end;

Procedure CHRSelect(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case (Where AND $7) of
  $0:MP.SetCHR_0000_03FF(What);
  $1:MP.SetCHR_0400_07FF(What);
  $2:MP.SetCHR_0800_0BFF(What);
  $3:MP.SetCHR_0C00_0FFF(What);
  $4:MP.SetCHR_1000_13FF(What);
  $5:MP.SetCHR_1400_17FF(What);
  $6:MP.SetCHR_1800_1BFF(What);
  $7:MP.SetCHR_1C00_1FFF(What);
 end;
end;


Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
 MI[0] := b9xxx;
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
 b9xxx := MI[0];
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper32',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 MP.SetWriteHandler($8,PRG1Select);
 MP.SetWriteHandler($9,BankMirror);
 MP.SetWriteHandler($A,PRG2Select);
 MP.SetWriteHandler($B,CHRSelect);

 MP.SetPRG_89AB(0);
 MP.SetPRG_CDEF(-1);

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI;

begin
end.
