library Map033;

uses
  Windows,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 33;
  VersionLo : 0;
  VersionHi : 1;
  BankSize  : 8192;
  Name      : 'Taito TC0190';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions

Procedure MapWrite1(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where of
  $000:MP.SetPRG_89(What);
  $001:MP.SetPRG_AB(What);
  $002:MP.SetCHR_0000_07FF(What);
  $003:MP.SetCHR_0800_0FFF(What);
  Else MP.DbgOut('Ouch 1');
 end;
end;

Procedure MapWrite2(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where of
  $000:MP.SetCHR_1000_13FF(What);
  $001:MP.SetCHR_1400_17FF(What);
  $002:MP.SetCHR_1800_1BFF(What);
  $003:MP.SetCHR_1C00_1FFF(What);
  Else MP.DbgOut('Ouch 2');
 end;
end;

Procedure MapMirror1(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where of
  $000:If (What <> 0) then MP.Mirror_H else MP.Mirror_V;
 end;
end;

Procedure MapMirror2(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where of
  $000:If (What <> 0) then MP.Mirror_H else MP.Mirror_V;
 end;
end;

Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
 // Mapper 0, does nothing extra ktnx.
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper33',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 MP.SetWriteHandler($8,MapWrite1);
 MP.SetWriteHandler($A,MapWrite2);
 MP.SetWriteHandler($C,MapMirror1);
 MP.SetWriteHandler($E,MapMirror2);

 MP.SetPRG_89AB(0);
 MP.SetPRG_CDEF(-1);

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI;

begin
end.
