library Map034;

uses
  Windows,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 34;
  VersionLo : 0;
  VersionHi : 1;
  BankSize  : 32768;
  Name      : 'Nina-1';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions

Procedure MapperWrite1(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where of
  $FFD:MP.SetPRG_89ABCDEF(What);
  $FFE:MP.SetCHR_0000_0FFF(What);
  $FFF:MP.SetCHR_1000_1FFF(What);
  Else MP.DbgOut('Ouch 1');
 end;
end;

Procedure MapperWrite2(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
  MP.SetPRG_89ABCDEF(What);
end;

Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper34',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
var
 X:LongInt;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 MP.SetWriteHandler($7,MapperWrite1);
 For X := $8 to $F do
  MP.SetWriteHandler(X,MapperWrite2);

 MP.SetPRG_89ABCDEF(0);

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI;

begin
end.
