library Map040;

uses
  Windows,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 40;
  VersionLo : 0;
  VersionHi : 1;
  BankSize  : 8192;
  Name      : 'SMB2j Bootlegged!';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions
 IRQCounter,IRQEnabled:Byte;

Procedure PRGChange(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 MP.SetPRG_CD(What);
end;

Procedure IRQReset(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 IRQEnabled := 0;
 IRQCounter := 36;
end;

Procedure IRQEnable(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 IRQEnabled := 1;
end;

Function  HBlank(ScanLine:LongInt; Byte2001:LongInt):LongInt; cDecl;
begin
 Result := 0;
 If (IRQEnabled <> 0) then
  begin
   Dec(IRQCounter);
   If (IRQCounter = 0) then Result := 1;
  end;
end;

Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
 MI[0] := IRQCounter;
 MI[1] := IRQEnabled;
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
 IRQCounter := MI[0];
 IRQEnabled := MI[1];
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper40',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 MP.SetWriteHandler($8,IRQReset);
 MP.SetWriteHandler($9,IRQReset);
 MP.SetWriteHandler($A,IRQEnable);
 MP.SetWriteHandler($B,IRQEnable);
 MP.SetWriteHandler($E,PRGChange);
 MP.SetWriteHandler($F,PRGChange);

 MP.SetPRG_67(6);
 MP.SetPRG_89ABCDEF(-1);

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI,HBlank;

begin
end.
