library Map041;

uses
  Windows,
//  SysUtils,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 41;
  VersionLo : 0;
  VersionHi : 1;
  BankSize  : 32768;
  Name      : 'Caltron 6-in-1';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions
 Chr_Bits:Byte;
 Reg2Enabled:Boolean;

Procedure RegWrite1(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
// MP.DbgOut(PChar(IntToHex(Page,1)+IntToHex(Where,3)+':'+IntToHex(What,2)));
 If (Where AND $20) <> 0 then
  MP.Mirror_H else MP.Mirror_V;
 Reg2Enabled := (Where AND $4) <> 0;
 Chr_Bits := (Chr_Bits AND Not(4+8)) OR ((Where shr 1) AND (4+8));
 MP.SetPRG_89ABCDEF(Where AND $7);
end;

Procedure RegWrite2(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
// MP.DbgOut(PChar(IntToHex(Page,1)+IntToHex(Where,3)+':'+IntToHex(What,2)));
 If Not(Reg2Enabled) then exit;
 MP.SetCHR_0000_1FFF(Chr_Bits OR (Where AND (1+2)));
end;

Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
 MI[0] := Byte(Reg2Enabled);
 MI[1] := Chr_Bits;
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
 Reg2Enabled := Boolean(MI[0]);
 Chr_Bits := MI[1];
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper -1',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
var
 X:LongInt;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 MP.SetWriteHandler($6,RegWrite1);
 For X := $8 to $F do
  MP.SetWriteHandler(X,RegWrite2);

 MP.SetPRG_89ABCDEF(0);

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI;

begin
end.
