library Map065;

uses
  Windows,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 65;
  VersionLo : 0;
  VersionHi : 1;
  BankSize  : 8192;
  Name      : 'Irem H-3001';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions
 IRQEnabled:Byte;
 IRQCounter:Byte;

Procedure PRGSel1(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (Where = 0) then
  MP.SetPRG_89(What);
end;

Procedure PRGSel2(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (Where = 0) then
  MP.SetPRG_AB(What);
end;

Procedure PRGSel3(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (Where = 0) then
  MP.SetPRG_CD(What);
end;

Procedure CHRSel(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where of
  $000:MP.SetCHR_0000_03FF(What);
  $001:MP.SetCHR_0400_07FF(What);
  $002:MP.SetCHR_0800_0BFF(What);
  $003:MP.SetCHR_0C00_0FFF(What);
  $004:MP.SetCHR_1000_13FF(What);
  $005:MP.SetCHR_1400_17FF(What);
  $006:MP.SetCHR_1800_1BFF(What);
  $007:MP.SetCHR_1C00_1FFF(What);
 end;
end;

Procedure MirIRQ(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 Case Where of
  000:;
  001:If (What AND $80) = 0 then MP.Mirror_V else MP.Mirror_H;
  002:;
  003:;
  004:; //IRQEnabled := What AND Bit7;
  005:begin
//       DbgWnd.DbgInfo.Lines.Add('$900'+IntToHex(Where,1)+' : '+IntToHex(What,2));
       IRQCounter := What*2;
//       IRQEnabled := What;
      end;
  006:begin
//       DbgWnd.DbgInfo.Lines.Add('$900'+IntToHex(Where,1)+' : '+IntToHex(What,2));
       IRQEnabled := IRQCounter;
//       IRQEnabled := 1;
      end;
//  else DbgWnd.DbgInfo.Lines.Add('Unhandled!');
 end;
end;

Function  HBlank(ScanLine:LongInt; Byte2001:LongInt):LongInt; cDecl;
begin
 Result := 0;
 If (IRQEnabled <> 0) then
  begin
   Dec(IRQCounter);
   If (IRQCounter = $FF) then
    begin
     Result := 1;
//     IRQCounter := IRQLatch;
     IRQEnabled := 0;
    end;
  end;
end;

Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
 MI[0] := IRQEnabled;
 MI[1] := IRQCounter;
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
 IRQEnabled := MI[0];
 IRQCounter := MI[1];
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','Mapper65',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 MP.SetWriteHandler($8,PRGSel1);
 MP.SetWriteHandler($A,PRGSel2);
 MP.SetWriteHandler($C,PRGSel3);
 MP.SetWriteHandler($9,MirIRQ);
 MP.SetWriteHandler($B,CHRSel);

 MP.SetPRG_89AB(0);
 MP.SetPRG_CDEF(-1);

 If (MP.HasCHR_ROM <> 0) then
  MP.SetCHR_0000_1FFF(0)
 else
  MP.SetCHR_RAM(0);

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI,HBlank;

begin
end.
