library Map666;

uses
  Windows,
  MapperInfo in '..\MapperInfo.pas';

Const
 ThisMapperInfo:TMapperInfo = (
  MapperNum : 666;
  VersionLo : 0;
  VersionHi : 1;
  BankSize  : 4096;
  Name      : 'NSF File';
  Author    : 'TNSe');

Var
 MP:TMapperParam; // Contains all variables and mapper functions

Procedure MapperWrite(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 If (Where >= $FF8) then
  MP.SetPRG_Custom(Where AND $F,What,4096);
end;

Procedure VRC6Write(Page:LongInt; Where:LongInt; What:LongInt); cDecl;
begin
 MP.VRC6Write(Page-$9,Where,What);
end;


Procedure SaveMI(var MI:Ar128); cDecl; // Returns the data for saving in SNSS format
begin
end;

Procedure LoadMI(const MI:Ar128); cDecl;
begin
end;

Function  LoadMapper(VersionNeeded:LongInt):PMapperInfo; cDecl;
begin
 If (VersionNeeded > CurrentMapperInterface) then
  begin
   MessageBox(0,'DLL is not compatible with the current mapper interface!','NSF Mapper',0);
   Result := Nil;
  end
 else Result := @ThisMapperInfo;
end;

Procedure UnloadMapper; cDecl;
begin
 // Nothing 4 now.
end;

Procedure InitMapper(Const MapperParam:TMapperParam); cDecl;
begin
 // Copy the passed parameters to get access to the functions
 MP := MapperParam;

 MP.SetWriteHandler($5,MapperWrite);
 MP.SetReadHandler($5,MP.GetReadHandler($8));

 MP.SetWriteHandler($9,VRC6Write);
 MP.SetWriteHandler($A,VRC6Write);
 MP.SetWriteHandler($B,VRC6Write);

 MP.SetCHR_RAM(0); // only has VRAM :P

 if ((MP.Flag1 AND 1) <> 0) then
  MP.Mirror_V else MP.Mirror_H;

end;

Exports
 LoadMapper,UnloadMapper,InitMapper,SaveMI,LoadMI;

begin
end.
