#include	<stdio.h>
#include	<string.h>
#include	<malloc.h>
#include	"d_UNIF.h"

void	UNIF_SetMirroring (void (*MapMirror)(void))
{
	switch ((MP->Flags & 0x0F00) >> 8)
	{
	case 0:	MP->Mirror_H();	break;
	case 1:	MP->Mirror_V();	break;
	case 2:	MP->Mirror_S0();break;
	case 3:	MP->Mirror_S1();break;
	case 4:	MP->Mirror_4();	break;
	case 5:	if (!MapMirror)	break;
		MapMirror();	break;
	}
}

void	UNIF_InitSRAM (int Amt)
{
	if (MP->Flags & 0x0002)
		MP->Set_SRAMSize(Amt);
	UNIF_LoadSRAM();
}

void	UNIF_LoadSRAM (void)
{
	if (MP->Flags & 0x0002)
	{
		MP->Load_SRAM();
		MP->DbgOut("Save RAM loaded!");
	}
}

void	UNIF_SaveSRAM (void)
{
	if (MP->Flags & 0x0002)
	{
		MP->Save_SRAM();
		MP->DbgOut("Save RAM saved!");
	}
}

PMapperParam	MP;	/* Used by all mappers, might as well drop it in here */

/* NES: NES boards */
extern	CTMapperInfo
	MapperInfo_NES_AMROM,	MapperInfo_NES_ANROM,	MapperInfo_NES_AOROM,	MapperInfo_NES_BNROM,
	MapperInfo_NES_CNROM,	MapperInfo_NES_CPROM,	MapperInfo_NES_ELROM,	MapperInfo_NES_ETROM,
	MapperInfo_NES_EWROM,	MapperInfo_NES_GNROM,	MapperInfo_NES_HKROM,	MapperInfo_NES_JLROM,
	MapperInfo_NES_BTR,	MapperInfo_NES_MHROM,	MapperInfo_NES_NROM_128,MapperInfo_NES_RROM_128,
	MapperInfo_NES_NROM_256,MapperInfo_NES_SAROM,	MapperInfo_NES_SBROM,	MapperInfo_NES_SCROM,
	MapperInfo_NES_SEROM,	MapperInfo_NES_SGROM,	MapperInfo_NES_SKROM,	MapperInfo_NES_SLROM,
	MapperInfo_NES_SL1ROM,	MapperInfo_NES_SNROM,	MapperInfo_NES_SOROM,	MapperInfo_NES_TFROM,
	MapperInfo_NES_TGROM,	MapperInfo_NES_TKROM,	MapperInfo_NES_TLROM,	MapperInfo_NES_TR1ROM,
	MapperInfo_NES_TSROM,	MapperInfo_NES_UNROM,	MapperInfo_NES_UOROM,
/* HVC: Famicom boards */
	MapperInfo_BTL_MARIO1_MALEE2,
/* BTL: Pirate simgle-game carts */
/* BMC: Pirate multicarts */
	MapperInfo_BMC_1991SuperHiK7in1,	MapperInfo_BMC_1992Ballgames11in1,
	MapperInfo_BMC_1995SuperHiK4in1,	MapperInfo_BMC_Generic115in1,
	MapperInfo_BMC_Generic15in1,		MapperInfo_BMC_Generic20in1,
	MapperInfo_BMC_Generic20in1A,		MapperInfo_BMC_Generic42in1,
	MapperInfo_BMC_Generic52in1,		MapperInfo_BMC_Generic76in1,
	MapperInfo_BMC_GoldenGame150in1,	MapperInfo_BMC_Mario7in1,
	MapperInfo_BMC_NovelDiamond9999999in1,	MapperInfo_BMC_Reset4in1,
	MapperInfo_BMC_StudyGame32in1,		MapperInfo_BMC_Super1Min1,
	MapperInfo_BMC_Super700in1,		MapperInfo_BMC_Supervision16in1,
	MapperInfo_BMC_T3H53
	;

CTMapperInfo	MapperInfo_0 = {"",0,MS_None,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL};

static	CPMapperInfo	BoardTable[] =
{
	/* NES */
	&MapperInfo_NES_AMROM	,&MapperInfo_NES_ANROM	,&MapperInfo_NES_AOROM	,

	&MapperInfo_NES_BNROM	,

	&MapperInfo_NES_CNROM	,&MapperInfo_NES_CPROM	,

	&MapperInfo_NES_ELROM	,&MapperInfo_NES_ETROM	,&MapperInfo_NES_EWROM	,

	&MapperInfo_NES_GNROM	,

	&MapperInfo_NES_HKROM	,

	&MapperInfo_NES_JLROM	,&MapperInfo_NES_BTR	,

	&MapperInfo_NES_MHROM	,

	&MapperInfo_NES_NROM_128	,&MapperInfo_NES_RROM_128		,&MapperInfo_NES_NROM_256,

	&MapperInfo_NES_SAROM	,&MapperInfo_NES_SBROM	,&MapperInfo_NES_SCROM	,&MapperInfo_NES_SEROM	,
	&MapperInfo_NES_SGROM	,&MapperInfo_NES_SKROM	,&MapperInfo_NES_SLROM	,&MapperInfo_NES_SL1ROM	,
	&MapperInfo_NES_SNROM	,&MapperInfo_NES_SOROM	,

	&MapperInfo_NES_TFROM	,&MapperInfo_NES_TGROM	,&MapperInfo_NES_TKROM	,&MapperInfo_NES_TLROM	,
	&MapperInfo_NES_TR1ROM	,&MapperInfo_NES_TSROM	,

	&MapperInfo_NES_UNROM	,&MapperInfo_NES_UOROM	,
	/* Famicom */
	&MapperInfo_BTL_MARIO1_MALEE2	,
	/* Bootleg Singles */
	/* Bootleg Multicarts */
	&MapperInfo_BMC_1991SuperHiK7in1	,&MapperInfo_BMC_1992Ballgames11in1	,
	&MapperInfo_BMC_1995SuperHiK4in1	,&MapperInfo_BMC_Generic115in1		,
	&MapperInfo_BMC_Generic15in1		,&MapperInfo_BMC_Generic20in1		,
	&MapperInfo_BMC_Generic20in1A		,&MapperInfo_BMC_Generic42in1		,
	&MapperInfo_BMC_Generic52in1		,&MapperInfo_BMC_Generic76in1		,
	&MapperInfo_BMC_GoldenGame150in1	,&MapperInfo_BMC_Mario7in1		,
	&MapperInfo_BMC_NovelDiamond9999999in1	,&MapperInfo_BMC_Reset4in1		,
	&MapperInfo_BMC_StudyGame32in1		,&MapperInfo_BMC_Super1Min1		,
	&MapperInfo_BMC_Super700in1		,&MapperInfo_BMC_Supervision16in1	,
	&MapperInfo_BMC_T3H53			,
	/* Null-terminator */
	&MapperInfo_0
};

static	CPMapperInfo	LoadBoard (char *Board)
{
	int x = 0;
	char *BoardName = _strdup(Board);
	if ((!strncmp(BoardName,"BTL-",4)) || (!strncmp(BoardName,"HVC-",4)))
		strncpy(BoardName,"NES-",4);
	for (x = 0; BoardTable[x]->BoardName[0]; x++)
	{
		if ((!strcmp(BoardTable[x]->BoardName,BoardName)) || (!strcmp(BoardTable[x]->BoardName,Board)))
		{
			free(BoardName);
			return BoardTable[x];
		}
	}
	free(BoardName);
	return NULL;
}

static	CPMapperInfo	NotSupported (int Mapper)
{
	return NULL;
}

static	TDLLInfo	DLL_Info =
{
	"The Quietust <quietust@ircN.org>",
	0x20010305,		/* Date */
	0x00010001,		/* Version 1.1 */
	NotSupported,
	LoadBoard
};

__declspec(dllexport)	PDLLInfo	Load_DLL (int VersionRequired)
{
	if (VersionRequired != CurrentMapperInterface)
	{
		MessageBox(0,"Mapper interface incompatible!","Mappers",MSGBOX_FLAGS);
		return NULL;
	}
	return &DLL_Info;
}

__declspec(dllexport)	void	Unload_DLL (void)
{
}