#include	"s_FDS.h"

/*
 * Code borrowed from NEZplug until I can write better code myself
 * Currently does not work properly
 */

#define LOG_BITS 12
#define LIN_BITS 6
#define LOG_LIN_BITS 30

u32 LinearToLog(s32 l);
s32 LogToLinear(u32 l, u32 sft);
void LogTableInitialize(void);

static u32 lineartbl[(1 << LIN_BITS) + 1];
static u32 logtbl[1 << LOG_BITS];
u32 LinearToLog(s32 l)
{
	return (l < 0) ? (lineartbl[-l] + 1) : lineartbl[l];
}

s32 LogToLinear(u32 l, u32 sft)
{
	s32 ret;
	u32 ofs;
	sft += (l >> 1) >> LOG_BITS;
	if (sft >= LOG_LIN_BITS) return 0;
	ofs = (l >> 1) & ((1 << LOG_BITS) - 1);
	ret = logtbl[ofs] >> sft;
	return (l & 1) ? -ret : ret;
}

void LogTableInitialize(void)
{
	static u32 initialized = 0;
	u32 i;
	double a;
	if (initialized) return;
	initialized = 1;
	for (i = 0; i < (1 << LOG_BITS); i++)
	{
		a = (1 << LOG_LIN_BITS) / pow(2, i / (double)(1 << LOG_BITS));
		logtbl[i] = (u32)a;
	}
	lineartbl[0] = LOG_LIN_BITS << LOG_BITS;
	for (i = 1; i < (1 << LIN_BITS) + 1; i++)
	{
		u32 ua;
		a = i << (LOG_LIN_BITS - LIN_BITS);
		ua = (u32)((LOG_LIN_BITS - (log(a) / log(2))) * (1 << LOG_BITS));
		lineartbl[i] = ua << 1;
	}
}

#define NES_BASECYCLES (21477270)
#define CPS_SHIFT (23)
#define PHASE_SHIFT (23)
#define FADEOUT_SHIFT 11/*(11)*/
#define XXX_SHIFT 1 /* 3 */

typedef	struct	{
	u32 wave[0x40];
	u32 envspd;
	s32 envphase;
	u32 envout;
	u32 outlvl;

	u32 phase;
	u32 spd;
	u32 volume;
	s32 sweep;

	u8 enable;
	u8 envmode;
	u8 xxxxx;
	u8 xxxxx2;
} FDS_FMOP;

typedef struct FDSSOUND {
	u32 cps;
	s32 cycles;
	u32 mastervolume;
	s32 output;

	FDS_FMOP op[2];

	u32 waveaddr;
	u8 mute;
	u8 key;
	u8 reg[0x10];
} FDSSOUND;


static FDSSOUND fdssound;

static s16 FDSSoundRender(void)
{
	FDS_FMOP *pop;

	for (pop = &fdssound.op[0]; pop < &fdssound.op[2]; pop++)
	{
		u32 vol;
		if (pop->envmode)
		{
			pop->envphase -= fdssound.cps >> (FADEOUT_SHIFT - XXX_SHIFT);
			if (pop->envmode & 0x40)
				while (pop->envphase < 0)
				{
					pop->envphase += pop->envspd;
					pop->volume += (pop->volume < 0x1f);
				}
			else
				while (pop->envphase < 0)
				{
					pop->envphase += pop->envspd;
					pop->volume -= (pop->volume > 0x00);
				}
		}
		vol = pop->volume;
		if (vol)
		{
			vol += pop->sweep;
			if (vol < 0)
				vol = 0;
			else if (vol > 0x3f)
				vol = 0x3f;
		}
		pop->envout = LinearToLog(vol);
	}
	fdssound.op[1].envout += fdssound.mastervolume;

	fdssound.cycles -= fdssound.cps;
	while (fdssound.cycles < 0)
	{
		fdssound.cycles += 1 << CPS_SHIFT;
		fdssound.output = 0;
		for (pop = &fdssound.op[0]; pop < &fdssound.op[2]; pop++)
		{
			if (!pop->spd || !pop->enable)
			{
				fdssound.output = 0;
				continue;
			}
			pop->phase += pop->spd + fdssound.output;
			fdssound.output = LogToLinear(pop->envout + pop->wave[(pop->phase >> (PHASE_SHIFT - XXX_SHIFT)) & 0x3f], pop->outlvl);
		}
	}
	if (fdssound.mute) return 0;
	return (s16)(fdssound.output);
}

void FDSSoundWrite(int address, int value)
{
	if (0x4040 <= address && address <= 0x407F)
	{
		fdssound.op[1].wave[address - 0x4040] = LinearToLog(((s32)value & 0x3f) - 0x20);
	}
	else if (0x4080 <= address && address <= 0x408F)
	{
		int ch = (address < 0x4084);
		FDS_FMOP *pop = &fdssound.op[ch];
		fdssound.reg[address - 0x4080] = value;
		switch (address & 15)
		{
			case 0:	case 4:
				if (value & 0x80)
				{
					pop->volume = (value & 0x3f);
					pop->envmode = 0;
				}
				else
				{
					pop->envspd = ((value & 0x3f) + 1) << CPS_SHIFT;
					pop->envmode = 0x80 | value;
				}
				break;
			case 1:	case 5:
				if (!value) break;
				if ((value & 0x7f) < 0x60)
					pop->sweep = value & 0x7f;
				else
					pop->sweep = ((s32)value & 0x7f) - 0x80;
				break;
			case 2:	case 6:
				pop->spd &= 0x00000F00 << 7;
				pop->spd |= (value & 0xFF) << 7;
				break;
			case 3:	case 7:
				pop->spd &= 0x000000FF << 7;
				pop->spd |= (value & 0x0F) << (7 + 8);
				pop->enable = !(value & 0x80);
				break;
			case 8:
				{
					static s8 lfotbl[8] = { 0,1,2,3,-4,-3,-2,-1 };
					u32 v = LinearToLog(lfotbl[value & 7]);
					fdssound.op[0].wave[fdssound.waveaddr++] = v;
					fdssound.op[0].wave[fdssound.waveaddr++] = v;
					if (fdssound.waveaddr == 0x40)
					{
						fdssound.waveaddr = 0;
					}
				}
				break;
			case 9:
				fdssound.op[0].outlvl = LOG_LIN_BITS - LIN_BITS - LIN_BITS - 10 - (value & 3);
				break;
			case 10:
				fdssound.op[1].outlvl = LOG_LIN_BITS - LIN_BITS - LIN_BITS - 10 - (value & 3);
				break;
		}
	}
}

int FDSSoundRead(int address)
{
	if (0x4090 <= address && address <= 0x409F)
	{
		return fdssound.reg[address - 0x4090];
	}
	return 0;
}

static u32 DivFix(u32 p1, u32 p2, u32 fix)
{
	u32 ret;
	ret = p1 / p2;
	p1  = p1 % p2;/* p1 = p1 - p2 * ret; */
	while (fix--)
	{
		p1 += p1;
		ret += ret;
		if (p1 >= p2)
		{
			p1 -= p2;
			ret++;
		}
	}
	return ret;
}

void FDSSoundReset(void)
{
	int i;
	LogTableInitialize();
	memset(&fdssound, 0, sizeof(FDSSOUND));
	fdssound.cps = DivFix(NES_BASECYCLES, 12 * (1 << XXX_SHIFT) * 44100, CPS_SHIFT);
	fdssound.op[0].enable = 1;
	fdssound.op[1].enable = 1;
	fdssound.op[0].outlvl = LOG_LIN_BITS - LIN_BITS - LIN_BITS - 10;
	fdssound.op[1].outlvl = LOG_LIN_BITS - LIN_BITS - LIN_BITS - 10;
	for (i = 0; i < 0x40; i++)
		fdssound.op[1].wave[i] = LinearToLog((i < 0x20)?0x1f:-0x20);
	fdssound.mastervolume = 0x3;
}


void	GetFDSSnd (s16 *Target, int Size)
{
/*	int x;
	for (x = 0; x < Size; x++)
		Target[x] += FDSSoundRender() >> 8;
*/
}