#ifndef __FMOPL_H_
#define __FMOPL_H_
#include "..\..\interface.h"

typedef void (*OPL_TIMERHANDLER)(int channel,double interval_Sec);
typedef void (*OPL_IRQHANDLER)(int param,int irq);
typedef void (*OPL_UPDATEHANDLER)(int param,int min_interval_us);
typedef void (*OPL_PORTHANDLER_W)(int param,unsigned char data);
typedef unsigned char (*OPL_PORTHANDLER_R)(int param);

/* !!!!! here is private section , do not access there member direct !!!!! */

#define OPL_TYPE_WAVESEL   0x01  /* waveform select    */
#define OPL_TYPE_ADPCM     0x02  /* DELTA-T ADPCM unit */
#define OPL_TYPE_KEYBOARD  0x04  /* keyboard interface */
#define OPL_TYPE_IO        0x08  /* I/O port */

/* ---------- OPL one of slot  ---------- */
typedef struct fm_opl_slot {
	s32	hippy;
	s32	TL;	/* total level     :TL << 8            */
	s32	TLL;	/* adjusted now TL                     */
	u8	KSR;	/* key scale rate  :(shift down bit)   */
	s32 *	AR;	/* attack rate     :&AR_TABLE[AR<<2]   */
	s32 *	DR;	/* decay rate      :&DR_TALBE[DR<<2]   */
	s32	SL;	/* sustin level    :SL_TALBE[SL]       */
	s32 *	RR;	/* release rate    :&DR_TABLE[RR<<2]   */
	u8	ksl;	/* keyscale level  :(shift down bits)  */
	u8	ksr;	/* key scale rate  :kcode>>KSR         */
	u32	mul;	/* multiple        :ML_TABLE[ML]       */
	u32	Cnt;	/* frequency count :                   */
	u32	Incr;	/* frequency step  :                   */
	/* envelope generator state */
	u8	eg_typ;	/* envelope type flag                  */
	u8	evm;	/* envelope phase                      */
	s32	evc;	/* envelope counter                    */
	s32	eve;	/* envelope counter end point          */
	s32	evs;	/* envelope counter step               */
	s32	evsa;	/* envelope step for AR :AR[ksr]       */
	s32	evsd;	/* envelope step for DR :DR[ksr]       */
	s32	evsr;	/* envelope step for RR :RR[ksr]       */
	/* LFO */
	u8	ams;	/* ams flag                            */
	u8	vib;	/* vibrate flag                        */
	/* wave selector */
	s32 **	wavetable;
} OPL_SLOT;

/* ---------- OPL one of channel  ---------- */
typedef struct fm_opl_channel {
	OPL_SLOT SLOT[2];
	u8	CON;		/* connection type                     */
	u8	FB;		/* feed back       :(shift down bit)   */
	s32 *	connect1;	/* slot1 output pointer                */
	s32 *	connect2;	/* slot2 output pointer                */
	s32	op1_out[2];	/* slot1 output for selfeedback        */
	/* phase generator state */
	u32	block_fnum;	/* block+fnum      :                   */
	u8	kcode;		/* key code        : KeyScaleCode      */
	u32	fc;		/* Freq. Increment base                */
	u32	ksl_base;	/* KeyScaleLevel Base step             */
	u8	keyon;		/* key on/off flag                     */
} OPL_CH;

/* OPL state */
typedef struct fm_opl_f {
	u8	type;		/* chip type                         */
	int	clock;		/* master clock  (Hz)                */
	int	rate;		/* sampling rate (Hz)                */
	double	freqbase;	/* frequency base                    */
	double	TimerBase;	/* Timer base time (==sampling time) */
	u8	address;	/* address register                  */
	u8	status;		/* status flag                       */
	u8	statusmask;	/* status mask                       */
	u32	mode;		/* Reg.08 : CSM , notesel,etc.       */
	/* Timer */
	int	T[2];		/* timer counter       */
	u8	st[2];		/* timer enable        */
	/* FM channel slots */
	OPL_CH *P_CH;		/* pointer of CH       */
	int	max_ch;		/* maximum channel     */
	/* Rythm sention */
	u8	rythm;		/* Rythm mode , key flag */

	/* time tables */
	s32	AR_TABLE[75];	/* atttack rate tables */
	s32	DR_TABLE[75];	/* decay rate tables   */
	u32	FN_TABLE[1024];	/* fnumber -> increment counter */
	/* LFO */
	s32 *	ams_table;
	s32 *	vib_table;
	s32	amsCnt;
	s32	amsIncr;
	s32	vibCnt;
	s32	vibIncr;
	/* wave selector enable flag */
	u8	wavesel;
	/* external event callback handler */
	OPL_TIMERHANDLER	TimerHandler;	/* TIMER handler   */
	int	TimerParam;			/* TIMER parameter */
	OPL_IRQHANDLER		IRQHandler;	/* IRQ handler    */
	int	IRQParam;			/* IRQ parameter  */
	OPL_UPDATEHANDLER	UpdateHandler;	/* stream update handler   */
	int	UpdateParam;			/* stream update parameter */
} FM_OPL;

/* ---------- Generic interface section ---------- */
#define OPL_TYPE_YM3812 (OPL_TYPE_WAVESEL)

FM_OPL *OPLCreate(int type, int clock, int rate);
void OPLDestroy(FM_OPL *OPL);
void OPLSetTimerHandler(FM_OPL *OPL,OPL_TIMERHANDLER TimerHandler,int channelOffset);
void OPLSetIRQHandler(FM_OPL *OPL,OPL_IRQHANDLER IRQHandler,int param);
void OPLSetUpdateHandler(FM_OPL *OPL,OPL_UPDATEHANDLER UpdateHandler,int param);

void OPLResetChip(FM_OPL *OPL);
int OPLWrite(FM_OPL *OPL,int a,int v);
unsigned char OPLRead(FM_OPL *OPL,int a);
int OPLTimerOver(FM_OPL *OPL,int c);

/* YM3626/YM3812 local section */
void YM3812UpdateOne(FM_OPL *OPL, s16 *buffer, int length);

#endif /* __FMOPL_H_ */
