#include	"s_MMC5.h"

TMMC5sound	MMC5sound;

static	TMMC5sound_data	MMC5sound_data = {
	{	{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,-4,-4},	// 87.5%
		{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,-4,-4,-4,-4},	// 75.0%
		{ 4, 4, 4, 4, 4, 4, 4, 4,-4,-4,-4,-4,-4,-4,-4,-4},	// 50.0%
		{ 4, 4, 4, 4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4}	// 25.0%
	},

	{	DLAY_CONST_INT*5  ,DLAY_CONST_INT*127,DLAY_CONST_INT*10 ,DLAY_CONST_INT*1  ,
		DLAY_CONST_INT*20 ,DLAY_CONST_INT*2  ,DLAY_CONST_INT*40 ,DLAY_CONST_INT*3  ,
		DLAY_CONST_INT*80 ,DLAY_CONST_INT*4  ,DLAY_CONST_INT*30 ,DLAY_CONST_INT*5  ,
		DLAY_CONST_INT*7  ,DLAY_CONST_INT*6  ,DLAY_CONST_INT*13 ,DLAY_CONST_INT*7  ,
		DLAY_CONST_INT*6  ,DLAY_CONST_INT*8  ,DLAY_CONST_INT*12 ,DLAY_CONST_INT*9  ,
		DLAY_CONST_INT*24 ,DLAY_CONST_INT*10 ,DLAY_CONST_INT*48 ,DLAY_CONST_INT*11 ,
		DLAY_CONST_INT*96 ,DLAY_CONST_INT*12 ,DLAY_CONST_INT*36 ,DLAY_CONST_INT*13 ,
		DLAY_CONST_INT*8  ,DLAY_CONST_INT*14 ,DLAY_CONST_INT*16 ,DLAY_CONST_INT*15
	}
};

static	void	MMC5_GenerateSquare (PMMC5sqr ChanData, s16 *Target, int Size)
{
	int x, y, LDuty, Vol;
	for (y = 0; y < Size; y++)
	{
		if (ChanData->freq <= 4)
			return;
		LDuty = MMC5sound_data.Duties[ChanData->duty][ChanData->CurD];
		ChanData->LCtr -= NES_INC_SIZE_INT;
		if (ChanData->LCtr < 0)
		{
			x = (-ChanData->LCtr / ((ChanData->freq + 1) << 16)) + 1;
			ChanData->CurD += x;
			ChanData->CurD &= 0xF;
			ChanData->LCtr += x * ((ChanData->freq + 1) << 16);
		}
		if (!ChanData->wavehold)
		{
			ChanData->Timer -= NUM_MS_FRAME_INT;
			if (ChanData->Timer < 0)
			{
				LDuty = 0;
				ChanData->Timer = 0;
			}
		}
		if (!ChanData->envelope)
		{
			Vol = ChanData->Envelope;
			ChanData->EnvCtr -= NUM_MS_FRAME_INT;
			if (ChanData->EnvCtr < 0)
			{
				ChanData->EnvCtr += (ChanData->volume+1)*QUARTER_VBLANK_INT;
				ChanData->Envelope--;
				Vol = ChanData->Envelope;
				if (ChanData->Envelope < 0)
				{
					LDuty = 0;
					if (ChanData->wavehold)
						ChanData->Envelope = 15;
					else	ChanData->Envelope = 0;
				}
			}
		}
		else	Vol = ChanData->volume;
		Target[y] += LDuty*Vol;
	}
}

void	MMC5sound_init (void)
{
	memset(&MMC5sound.Sqr0,0,sizeof(TMMC5sqr));
	memset(&MMC5sound.Sqr1,0,sizeof(TMMC5sqr));
}

void	SetMMC5Snd (int Chan, int Reg, int What)
{
	switch (Chan)
	{
	case 0:	switch (Reg)
		{
		case 0:	MMC5sound.Sqr0.byte0 = What;	break;
		case 2:	MMC5sound.Sqr0.byte2 = What;	break;
		case 3:	MMC5sound.Sqr0.byte3 = What;
			MMC5sound.Sqr0.Timer = MMC5sound_data.DLays[MMC5sound.Sqr0.length];
			MMC5sound.Sqr0.LCtr = (MMC5sound.Sqr0.freq + 1) << 16;
			MMC5sound.Sqr0.Envelope = 15;	break;
		}				break;
	case 1:	switch (Reg)
		{
		case 0:	MMC5sound.Sqr1.byte0 = What;	break;
		case 2:	MMC5sound.Sqr1.byte2 = What;	break;
		case 3:	MMC5sound.Sqr1.byte3 = What;
			MMC5sound.Sqr1.Timer = MMC5sound_data.DLays[MMC5sound.Sqr1.length];
			MMC5sound.Sqr1.LCtr = (MMC5sound.Sqr1.freq + 1) << 16;
			MMC5sound.Sqr1.Envelope = 15;	break;
		}				break;
	case 2:	if ((Reg == 5010) && (What & 1))
			MP->DbgOut("Ack! MMC5 RAW PCM is being used!");
		// here's $5010/$5011, gonna do that later
						break;
	case 3:	if (What & 0x01)
			MMC5sound.Sqr0.Enabled = 1;
		else
		{
			MMC5sound.Sqr0.Enabled = 0;
			MMC5sound.Sqr0.Timer = 0;
			MMC5sound.Sqr0.wavehold = 0;
		}
		if (What & 0x02)
			MMC5sound.Sqr1.Enabled = 1;
		else
		{
			MMC5sound.Sqr1.Enabled = 0;
			MMC5sound.Sqr1.Timer = 0;
			MMC5sound.Sqr1.wavehold = 0;
		}				break;
	}
}


void	GetMMC5Snd (s16 *Target, int Size)
{
	if (MMC5sound.Sqr0.Enabled)	MMC5_GenerateSquare(&MMC5sound.Sqr0,Target,Size);
	if (MMC5sound.Sqr1.Enabled)	MMC5_GenerateSquare(&MMC5sound.Sqr1,Target,Size);
/*	MMC5_GeneratePCM(&MMC5sound.PCM,Target,Size); */
}