#ifndef	__SND_MMC5_H__
#define	__SND_MMC5_H__

#include	"..\..\interface.h"

#define	NES_INC_SIZE_INT	(204800000 / 77)
#define	DLAY_CONST_INT		(65536000 / 60)
#define	NUM_MS_FRAME_INT	(65536000 / 44100)
#define	QUARTER_VBLANK_INT	(65536000 / 240)

typedef	struct	MMC5Sqr
{
	union
	{
		struct
		{
			unsigned volume  : 4;
			unsigned envelope: 1;
			unsigned wavehold: 1;
			unsigned duty    : 2;
			unsigned         : 8;
			unsigned freq    :11;
			unsigned length  : 5;
		};
		struct
		{
			unsigned byte0   : 8;
			unsigned         : 8;
			unsigned byte2   : 8;
			unsigned byte3   : 8;
		};
	};
	int CurD;
	int LCtr;
	int Timer;
	int EnvCtr, Envelope;
	int Enabled;
}	TMMC5sqr, *PMMC5sqr;

typedef	struct	MMC5sound
{
	TMMC5sqr Sqr0, Sqr1;
}	TMMC5sound, *PMMC5sound;

extern	TMMC5sound	MMC5sound;

typedef	struct	MMC5sound_data
{
	const int Duties[4][16];
	const int DLays[32];
}	TMMC5sound_data, *PMMC5sound_data;

void	MMC5sound_init (void);
void	SetMMC5Snd (int,int,int);
void	GetMMC5Snd (s16 *,int);

#endif	/* __SND_MMC5_H__ */