#include	"s_VRC6.h"

TVRC6sound	VRC6sound;

static	void	VRC6_GenerateSaw (PVRC6saw ChanData, s16 *Target, int Size)
{
	int x;
	for (x = 0; x < Size; x++)
	{
		ChanData->LCtr -= NES_INC_SIZE_INT;
		while (ChanData->LCtr < 0)
		{
			ChanData->CurP += ChanData->volume;
			ChanData->Acc++;
			ChanData->Acc %= 7;
			if (ChanData->Acc == 0)
				ChanData->CurP = 0;
			ChanData->LCtr += (ChanData->freq + 1) << 17; /* (foo << 16) * 2 */
		}
		Target[x] += (u8)(ChanData->CurP & 0xFF);
	}
}

static	void	VRC6_GenerateSquare (PVRC6sqr ChanData, s16 *Target, int Size)
{
	int x;
	for (x = 0; x < Size; x++)
	{
		ChanData->LCtr -= NES_INC_SIZE_INT;
		while (ChanData->LCtr < 0)
		{
			ChanData->CurP++;
			ChanData->CurP &= 0xF;
			ChanData->LCtr += (ChanData->freq + 1) << 16;
		}
		Target[x] += ChanData->volume * ((ChanData->CurP <= ChanData->duty) ? 4 : -4);
	}
}

void	VRC6sound_init (void)
{
	memset(&VRC6sound.Sqr[0],0,sizeof(TVRC6sqr));
	memset(&VRC6sound.Sqr[1],0,sizeof(TVRC6sqr));
	memset(&VRC6sound.Saw,0,sizeof(TVRC6saw));
}

void	SetVRC6Snd (int Which1, int Which2, int What)
{
	switch (Which1)
	{
	case 0:	switch (Which2)
		{
		case 0:	VRC6sound.Sqr[0].byte0 = What;	break;
		case 1:	VRC6sound.Sqr[0].byte1 = What;	break;
		case 2:	VRC6sound.Sqr[0].byte2 = What;	break;
		}				break;
	case 1:	switch (Which2)
		{
		case 0:	VRC6sound.Sqr[1].byte0 = What;	break;
		case 1:	VRC6sound.Sqr[1].byte1 = What;	break;
		case 2:	VRC6sound.Sqr[1].byte2 = What;	break;
		}				break;
	case 2:	switch (Which2)
		{
		case 0:	VRC6sound.Saw.byte0 = What;	break;
		case 1:	VRC6sound.Saw.byte1 = What;	break;
		case 2:	VRC6sound.Saw.byte2 = What;	break;
		}				break;
	}
}

void	GetVRC6Snd (s16 *Target, int Size)
{
	if (VRC6sound.Sqr[0].enabled)	VRC6_GenerateSquare(&VRC6sound.Sqr[0],Target,Size);
	if (VRC6sound.Sqr[1].enabled)	VRC6_GenerateSquare(&VRC6sound.Sqr[1],Target,Size);
	if (VRC6sound.Saw.enabled)	VRC6_GenerateSaw(&VRC6sound.Saw,Target,Size);
}