#ifndef	__SND_VRC6_H_
#define	__SND_VRC6_H_

#include	"..\..\interface.h"

#define	NES_INC_SIZE_INT (204800000 / 77)
// ~= 2659740

typedef	struct	VRC6Sqr
{
	union
	{
		struct
		{
			unsigned volume	: 4;
			unsigned duty	: 3;
			unsigned digital: 1;
			unsigned freq	:12;
			unsigned	: 3;
			unsigned enabled: 1;
			unsigned	: 8;
		};
		struct
		{
			unsigned byte0	: 8;
			unsigned byte1	: 8;
			unsigned byte2	: 8;
			unsigned	: 8;
		};
	};
	u32 CurP;
	int LCtr;
}	TVRC6sqr, *PVRC6sqr;

typedef	struct	VRC6saw
{
	union
	{
		struct
		{
			unsigned volume	: 6;
			unsigned 	: 2;
			unsigned freq	:12;
			unsigned	: 3;
			unsigned enabled: 1;
			unsigned	: 8;
		};
		struct
		{
			unsigned byte0	: 8;
			unsigned byte1	: 8;
			unsigned byte2	: 8;
			unsigned	: 8;
		};
	};
	u32 CurP;
	int LCtr;
	int Acc;
}	TVRC6saw, *PVRC6saw;

typedef	struct	VRC6sound
{
	TVRC6sqr Sqr[2];
	TVRC6saw Saw;
}	TVRC6sound, *PVRC6sound;

extern	TVRC6sound	VRC6sound;

void	VRC6sound_init (void);
void	SetVRC6Snd (int,int,int);
void	GetVRC6Snd (s16 *,int);

#endif	/* __SND_VRC6_H__ */
