#include	"h_74xx.h"

T_74xx	_74xx;

void	_74xx_Init (void (*Sync)(void), BOOL Reset, BOOL BusConflicts)
{
	u8 x;
	for (x = 0x8; x <= 0xF; x++)
		MP->SetWriteHandler(x,_74xx_Write);
	if (Reset)
	{
		_74xx.Data = 0;
		_74xx.Addr = 0;
	}
	_74xx.BusConflicts = BusConflicts;
	_74xx.Sync = Sync;
	_74xx.Sync();
}

int	_74xx_SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = _74xx.AddrL;
	MI[x++] = _74xx.AddrH;
	MI[x++] = _74xx.Data;
	return x;
}

int	_74xx_LoadMI (const Ar128 MI)
{
	u8 x = 0;
	_74xx.AddrL	= MI[x++];
	_74xx.AddrH	= MI[x++];
	_74xx.Data	= MI[x++];
	_74xx.Sync();
	return x;
}

void	_74xx_Write (int Bank, int Where, int What)
{
#ifdef BUS_CONFLICTS
	if ((_74xx.BusConflicts) && (MP->GetReadHandler(Bank)(Bank,Where) != What))
	{
		MP->DbgOut("Bus conflict!");
		return;
	}
#endif
	_74xx.Data = What;
	_74xx.Addr = (Bank << 12) | Where;
	_74xx.Sync();
}